<?php
/*
 * Filters for block patterns.
 */


/**
 * Replaces the default archive page hero section content in the BlockStrap theme.
 *
 * @param $content
 *
 * @return string
 */
function real_estate_theme_pattern_hero_archive_default( $content ) {
	ob_start();
	?>
	<!-- wp:blockstrap/blockstrap-widget-container {"bg_gradient":"linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)","mt_lg":"5","mb_lg":"","pt_lg":"5","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 pt-5 bg-image-fixed container position-relative"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","mb_lg":""} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mb_lg":""} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed text-start col"><!-- wp:blockstrap/blockstrap-widget-breadcrumb {"mt_lg":"1","pt_lg":"2","content":""} /-->

				<!-- wp:blockstrap/blockstrap-widget-archive-title {"prefix_hide":true,"text_color":"dark","font_size":"h2","font_weight":"font-weight-bold","mt_lg":"3","mb_lg":"4"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->
	<?php

	return ob_get_clean();
}
add_filter( 'blockstrap_pattern_hero_archive_default', 'real_estate_theme_pattern_hero_archive_default', 15 );

/**
 * @param $content
 *
 * @return false|string
 */
function real_estate_theme_pattern_hero_post_default( $content ) {
	ob_start();
	/*
	<?php esc_attr_e('Share','real-estate-listings'); ?>
	<?php esc_attr_e('Check this out!','real-estate-listings'); ?>
	*/
	?>

	<!-- wp:blockstrap/blockstrap-widget-container {"bg_color":"#0d1b48","text_color":"dark","mt_lg":"5","mb_lg":"4","pt_lg":"5","rounded":"rounded","rounded_size":"lg","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0d1b48'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='5'  mr_lg=''  mb_lg='4'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded='rounded'  rounded_size='lg'  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"mw-50 "} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mt-5 mb-4 pt-5 rounded-lg bg-image-fixed text-dark container position-relative rounded"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols_lg":"1","bg":"transparent","text_align_lg":"text-lg-start","mb_lg":"","className":"list-group-horizontal align-items-cente justify-content-center"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container row-cols-1 bg-transparent bg-image-fixed text-start row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mt_lg":"1","mb_lg":"0","pt_lg":"2","border":"0","display_lg":"d-lg-inline-block"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mt-1 mb-0 pt-2 border-0 bg-image-fixed text-start d-inline-block col"><!-- wp:blockstrap/blockstrap-widget-breadcrumb {"mb_lg":"1","pb_lg":"3","content":""} /-->

				<!-- wp:blockstrap/blockstrap-widget-post-title {"font_size":"h2","font_weight":"font-weight-bold"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container -->

		<!-- wp:blockstrap/blockstrap-widget-container {"container":"row","bg":"transparent","text_align_lg":"text-lg-start","mb_lg":"","className":"list-group-horizontal align-items-cente justify-content-center"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container bg-transparent bg-image-fixed text-start row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","bg":"transparent","mb_lg":"0","pt_lg":"0","border":"0"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-0 pt-0 border-0 bg-transparent bg-image-fixed col"><!-- wp:blockstrap/blockstrap-widget-post-info {"type":"date_published","date_format":"custom","date_custom":"j M Y","text_color":"muted","font_size":"fs-base","content":"\u003cspan class=\u0022text-muted fs-base  link-muted\u0022 \u003e\u003ci class=\u0022far fa-calendar me-2\u0022\u003e\u003c/i\u003e29 Jan 2025\u003c/span\u003e","sd_shortcode":"[bs_post_info type='date_published'  custom_meta=''  taxonomy='category'  taxonomy_limit=''  date_format='custom'  date_custom='j M Y'  is_link='false'  custom_url=''  icon_type=''  icon_class=''  before=''  after=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='muted'  font_size='fs-base'  font_size_custom=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  absolute_position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  zindex=''  visibility_conditions=''  css_class='' ]"} /-->

				<!-- wp:blockstrap/blockstrap-widget-post-info {"type":"read_time","date_format":"time-ago","link_size":"extra-small","link_bg":"primary","text_color":"muted","font_size":"fs-base","ml_lg":"4","content":"\u003cspan class=\u0022ms-4 text-muted fs-base  link-muted\u0022 \u003e\u003ci class=\u0022far fa-clock me-2\u0022\u003e\u003c/i\u003e5 min read\u003c/span\u003e","sd_shortcode":"[bs_post_info type='read_time'  custom_meta=''  taxonomy='category'  taxonomy_limit=''  date_format='time-ago'  date_custom=''  is_link='false'  custom_url=''  icon_type=''  icon_class=''  before=''  after=''  link_type=''  link_size='extra-small'  link_bg='primary'  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='muted'  font_size='fs-base'  font_size_custom=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg='4'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  absolute_position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  zindex=''  visibility_conditions=''  css_class='' ]"} /-->

				<!-- wp:blockstrap/blockstrap-widget-post-info {"type":"comments","date_format":"time-ago","text_color":"muted","font_size":"fs-base","ml_lg":"4","content":"\u003cspan class=\u0022ms-4 text-muted fs-base  link-muted\u0022 \u003e\u003ci class=\u0022far fa-comment me-2\u0022\u003e\u003c/i\u003e3 comments\u003c/span\u003e","sd_shortcode":"[bs_post_info type='comments'  custom_meta=''  taxonomy='category'  taxonomy_limit=''  date_format='time-ago'  date_custom=''  is_link='false'  custom_url=''  icon_type=''  icon_class=''  before=''  after=''  link_type=''  link_size=''  link_bg=''  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color='muted'  font_size='fs-base'  font_size_custom=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg='4'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  absolute_position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  zindex=''  visibility_conditions=''  css_class='' ]"} /-->

				<!-- wp:blockstrap/blockstrap-widget-post-info {"type":"taxonomy","taxonomy_limit":1,"date_format":"time-ago","is_link":true,"icon_type":"custom","link_type":"badge-round","link_bg":"danger","font_size":"0","ml_lg":"4","content":"\u003ca href=\u0022#\u0022 class=\u0022ms-4 badge rounded-pill text-bg-danger align-self-center\u0022 \u003eTaxonomy\u003c/a\u003e","sd_shortcode":"[bs_post_info type='taxonomy'  custom_meta=''  taxonomy='category'  taxonomy_limit='1'  date_format='time-ago'  date_custom=''  is_link='true'  custom_url=''  icon_type='custom'  icon_class=''  before=''  after=''  link_type='badge-round'  link_size=''  link_bg='danger'  link_pt=''  link_pr=''  link_pb=''  link_pl=''  link_pt_md=''  link_pr_md=''  link_pb_md=''  link_pl_md=''  link_pt_lg=''  link_pr_lg=''  link_pb_lg=''  link_pl_lg=''  link_divider=''  text_color=''  font_size='0'  font_size_custom=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  font_weight=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg='4'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  absolute_position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  zindex=''  visibility_conditions=''  css_class='' ]"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container -->

			<!-- wp:blockstrap/blockstrap-widget-container {"container":"col","bg":"transparent","text_align_lg":"text-lg-end","mb_lg":"0","pt_lg":"0","border":"0"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-0 pt-0 border-0 bg-transparent bg-image-fixed text-end col"><!-- wp:blockstrap/blockstrap-widget-share {"text":"<?php esc_attr_e('Share','real-estate-listings'); ?>","icon_class":"fas fa-share-alt fa-lg opacity-60","twitter_handel":"ayecode","share_text":"<?php esc_attr_e('Check this out!','real-estate-listings'); ?>","service_email":"1","service_link":"1","link_bg":"danger","text_color":"gray-dark","text_color_hover":"primary","font_size":"fs-base","styleid":"block-j0kau8j7vo","content":"\u003cdiv class=\u0022dropdown\u0022\u003e\u003ca   class=\u0022dropdown-toggle dropdown-toggle-0 nav-link text-gray-dark text-gray-dark fs-base block-j0kau8j7vo\u0022  data-bs-toggle=\u0022dropdown\u0022 aria-expanded=\u0022false\u0022\u003e\u003ci class=\u0022fas fa-share-alt fa-lg opacity-60 me-2\u0022\u003e\u003c/i\u003eShare\u003c/a\u003e \u003cdiv class=\u0022dropdown-menu dropdown-menu-end dropdown-caret-0 mt-2 text-muted \u0022\u003e\u003ca href=\u0022https://www.facebook.com/sharer/sharer.php?u=http%3A%2F%2Flocalhost%2Fwp-admin%2Fadmin-ajax.php\u0022 class=\u0022dropdown-item\u0022 target=\u0022_blank\u0022 onclick=\u0022javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=600,width=600');return false;\u0022\u003e\u003ci class=\u0022fab fa-facebook-f fa-fw opacity-75 fa-lg\u0022\u003e\u003c/i\u003e Facebook\u003c/a\u003e\u003ca href=\u0022https://twitter.com/share?url=http%3A%2F%2Flocalhost%2Fwp-admin%2Fadmin-ajax.php\u0026#038;via=ayecode\u0026#038;text=Check%20this%20out!\u0022 class=\u0022dropdown-item\u0022  target=\u0022_blank\u0022 onclick=\u0022javascript:window.open(this.href, '', 'menubar=no,toolbar=no,resizable=yes,scrollbars=yes,height=500,width=600');return false;\u0022\u003e\u003ci class=\u0022fab fa-twitter fa-fw opacity-75 fa-lg\u0022\u003e\u003c/i\u003e Twitter\u003c/a\u003e\u003ca href=\u0022https://www.linkedin.com/shareArticle?mini=true\u0026#038;url=http%3A%2F%2Flocalhost%2Fwp-admin%2Fadmin-ajax.php\u0022 class=\u0022dropdown-item\u0022  target=\u0022_blank\u0022\u003e\u003ci class=\u0022fab fa-linkedin-in fa-fw opacity-75 fa-lg\u0022\u003e\u003c/i\u003e Linkedin\u003c/a\u003e\u003ca href=\u0022mailto:?subject=Check+this+out%21+-+http%3A%2F%2Flocalhost\u0026body=I+thought+you+might+be+interested+in+this%3A+http%3A%2F%2Flocalhost%2Fwp-admin%2Fadmin-ajax.php\u0022 class=\u0022dropdown-item\u0022\u003e\u003ci class=\u0022far fa-envelope fa-fw opacity-75 fa-lg\u0022\u003e\u003c/i\u003e Email\u003c/a\u003e\u003ca href=\u0022http://localhost/wp-admin/admin-ajax.php\u0022 onclick=\u0022navigator.clipboard.writeText('http://localhost/wp-admin/admin-ajax.php');aui_toast('bs-blocks-copy-url','success','URL Copied to Clipboard');return false;\u0022 class=\u0022dropdown-item\u0022\u003e\u003ci class=\u0022fas fa-link fa-fw opacity-75 fa-lg\u0022\u003e\u003c/i\u003e Copy Link\u003c/a\u003e\u003c/div\u003e\u003cstyle\u003ehtml .editor-styles-wrapper .block-j0kau8j7vo:hover {color: var(\u002d\u002dwp\u002d\u002dpreset\u002d\u002dcolor\u002d\u002dprimary) !important;} \u003c/style\u003e\u003c/div\u003e","sd_shortcode":"[bs_share output_type=''  text='<?php esc_attr_e('Share','real-estate-listings'); ?>'  icon_class='fas fa-share-alt fa-lg opacity-60'  icon_position=''  service_facebook='1'  service_twitter='1'  twitter_handel='ayecode'  share_text='<?php esc_attr_e('Check this out!','real-estate-listings'); ?>'  service_linkedin='1'  service_email='1'  email_subject=''  email_body=''  service_link='1'  link_type=''  link_size=''  link_bg='danger'  link_bg_color='#0073aa'  link_bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  text_color='gray-dark'  text_color_custom=''  bg_hover=''  bg_hover_color='#0073aa'  bg_hover_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  text_color_hover='primary'  text_color_hover_custom=''  font_size='fs-base'  font_size_custom=''  font_weight=''  font_case=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  css_class=''  styleid='block-j0kau8j7vo' ]"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->

	<!-- wp:blockstrap/blockstrap-widget-container {"bg_color":"#0d1b48","text_color":"dark","mb_lg":"5","rounded":"rounded","rounded_size":"lg","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0d1b48'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded='rounded'  rounded_size='lg'  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"mw-50 "} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mb-5 rounded-lg bg-image-fixed text-dark container position-relative rounded"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols_lg":"1","bg":"transparent","text_align_lg":"text-lg-start","mb_lg":"","className":"list-group-horizontal align-items-cente justify-content-center"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container row-cols-1 bg-transparent bg-image-fixed text-start row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mb_lg":"0","pt_lg":"0","border":"0","display_lg":"d-lg-inline-block"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-0 pt-0 border-0 bg-image-fixed text-start d-inline-block col"><!-- wp:blockstrap/blockstrap-widget-image {"img_src":"featured","img_size":"large","img_alt":"Featured image","img_aspect":"21by9","img_rounded":"rounded","img_rounded_size":"3","content":"\u003cfigure class=\u0022  ratio ratio-21x9  embed-has-actionoverflow-hidden mb-3 \u0022 style=\u0022 \u0022\u003e\u003cimg src=\u0022http://localhost/wp-content/plugins/blockstrap-page-builder-blocks/assets/images/block-image-placeholder.jpg\u0022 class=\u0022mw-100 w-100 rounded rounded-3 embed-item-cover-xy  \u0022 /\u003e\u003c/figure\u003e","sd_shortcode":"[bs_image img_src='featured'  img_image=''  img_image_id=''  img_size='large'  img_url=''  fallback_img_src=''  fallback_img_image=''  fallback_img_image_id=''  img_alt='Featured image'  img_lazyload=''  img_link_to=''  img_link=''  img_link_lightbox=''  lightbox_size='full'  img_link_hover_effect=''  text=''  col=''  col_md=''  col_lg=''  img_aspect='21by9'  img_cover=''  img_border=''  img_rounded='rounded'  img_rounded_size='3'  img_shadow=''  img_overlay=''  text_color=''  font_size=''  font_size_custom=''  font_weight=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg_on_text='false'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  float=''  float_md=''  float_lg=''  img_mask=''  img_mask_position='center center'  visibility_conditions=''  css_class='' ]"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->
	<?php

	return ob_get_clean();
}
add_filter( 'blockstrap_pattern_hero_post_default', 'real_estate_theme_pattern_hero_post_default', 15 );

function real_estate_theme_pattern_hero_page_default( $content ) {
	ob_start();
	?>
	<!-- wp:blockstrap/blockstrap-widget-container {"bg_color":"#0d1b48","text_color":"dark","mt_lg":"9","mb_lg":"4","rounded":"rounded","rounded_size":"lg","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0d1b48'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='9'  mr_lg=''  mb_lg='4'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded='rounded'  rounded_size='lg'  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"mw-50 "} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mt-9 mb-4 rounded-lg bg-image-fixed text-dark container position-relative rounded"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols_lg":"1","bg":"transparent","text_align_lg":"text-lg-start","mb_lg":"","className":"list-group-horizontal align-items-cente justify-content-center"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container row-cols-1 bg-transparent bg-image-fixed text-start row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mt_lg":"n5","mb_lg":"0","pt_lg":"0","border":"0","display_lg":"d-lg-inline-block"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mt-n5 mb-0 pt-0 border-0 bg-image-fixed text-start d-inline-block col"><!-- wp:blockstrap/blockstrap-widget-post-title {"font_size":"h2","font_weight":"font-weight-bold"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->

	<!-- wp:blockstrap/blockstrap-widget-container {"bg_color":"#0d1b48","text_color":"dark","mb_lg":"5","rounded":"rounded","rounded_size":"lg","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0d1b48'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color='dark'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='5'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded='rounded'  rounded_size='lg'  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"mw-50 "} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mb-5 rounded-lg bg-image-fixed text-dark container position-relative rounded"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","row_cols_lg":"1","bg":"transparent","text_align_lg":"text-lg-start","mb_lg":"","className":"list-group-horizontal align-items-cente justify-content-center"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container row-cols-1 bg-transparent bg-image-fixed text-start row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mb_lg":"0","pt_lg":"0","border":"0","display_lg":"d-lg-inline-block"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-0 pt-0 border-0 bg-image-fixed text-start d-inline-block col"><!-- wp:blockstrap/blockstrap-widget-image {"img_src":"featured","img_size":"large","img_alt":"Feature image","img_aspect":"21by9","img_rounded":"rounded","img_rounded_size":"3","content": "","sd_shortcode":"[bs_image img_src='featured'  img_image=''  img_image_id=''  img_size='large'  img_url=''  fallback_img_src=''  fallback_img_image=''  fallback_img_image_id=''  img_alt='Feature image'  img_lazyload=''  img_link_to=''  img_link=''  img_link_lightbox=''  lightbox_size='full'  img_link_hover_effect=''  text=''  col=''  col_md=''  col_lg=''  img_aspect='21by9'  img_cover=''  img_border=''  img_rounded='rounded'  img_rounded_size='3'  img_shadow=''  img_overlay=''  text_color=''  font_size=''  font_size_custom=''  font_weight=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  bg_on_text='false'  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  float=''  float_md=''  float_lg=''  img_mask=''  img_mask_position='center center'  visibility_conditions=''  css_class='' ]"} /--></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->
	<?php

	return ob_get_clean();
}
add_filter( 'blockstrap_pattern_hero_page_default', 'real_estate_theme_pattern_hero_page_default', 15 );

/**
 * Replaces the default 404 page hero section content in the BlockStrap theme.
 *
 * @param $content
 *
 * @return string
 */
function real_estate_theme_pattern_hero_404_default( $content ) {
	ob_start();
	/*
	<?php esc_attr_e('404 Page not found','real-estate-listings'); ?>
	*/
	?>
	<!-- wp:blockstrap/blockstrap-widget-container {"bg_gradient":"linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)","mt_lg":"7","mb_lg":"","position":"position-relative","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgb(2,11,185) 2%,rgb(126,5,170) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg='7'  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container mt-7 bg-image-fixed container position-relative"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","mb_lg":"","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed row"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","text_align_lg":"text-lg-start","mb_lg":""} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container bg-image-fixed text-start col"><!-- wp:blockstrap/blockstrap-widget-breadcrumb {"content":""} /-->

				<!-- wp:blockstrap/blockstrap-widget-heading {"text":"<?php esc_attr_e('404 Page not found','real-estate-listings'); ?>","mt_lg":"2"} -->
				<h1 class="wp-block-blockstrap-blockstrap-widget-heading mt-2 mb-3"><?php esc_html_e('404 Page not found','real-estate-listings'); ?></h1>
				<!-- /wp:blockstrap/blockstrap-widget-heading --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->
	<?php

	return ob_get_clean();
}
add_filter( 'blockstrap_pattern_hero_404_default', 'real_estate_theme_pattern_hero_404_default', 15 );

/**
 * Replaces the default homepage hero section content in the BlockStrap theme.
 *
 * @param $content
 *
 * @return string
 */
function real_estate_theme_pattern_hero_home_default( $content ) {
	$img_url = esc_url( get_stylesheet_directory_uri() . '/assets/images/home-bg.jpg' ); /* <?php echo esc_url( $img_url ); ?> */
	ob_start();
	/*
	<?php esc_attr_e('Your Dream Home Starts Here','real-estate-listings'); ?>
	*/
	?>
	<!-- wp:blockstrap/blockstrap-widget-container {"container":"container-fluid","bg":"custom-color","bg_color":"rgba(0,0,0,0.35)","bg_gradient":"linear-gradient(135deg,rgb(30,23,126) 4%,rgb(96,41,182) 100%)","bg_image_fixed":true,"bg_image":"<?php echo esc_url( $img_url ); ?>","bg_image_xy":{"x":0.5,"y":0.68},"text_color":"white","mb_lg":"","pt_lg":"11","pb_lg":"8","position":"position-relative","display_lg":"d-lg-flex","flex_align_items_lg":"align-items-lg-center","css_class":"vh-100","sd_shortcode":"[bs_container container='container-fluid'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg='custom-color'  bg_color='rgba(0,0,0,0.35)'  bg_gradient='linear-gradient(135deg,rgb(30,23,126) 4%,rgb(96,41,182) 100%)'  bg_image_fixed='true'  bg_image_use_featured='false'  bg_image='<?php echo esc_url( $img_url ); ?>'  bg_image_id=''  bg_on_text='false'  text_color='white'  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg=''  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='11'  pr_lg=''  pb_lg='8'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position='position-relative'  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg='d-lg-flex'  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg='align-items-lg-center'  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='vh-100' ]","sd_shortcode_close":"[/bs_container]"} -->
	<div class="wp-block-blockstrap-blockstrap-widget-container pt-11 pb-8 bg-custom-color bg-image-fixed text-white d-flex container-fluid position-relative vh-100 align-items-center" style="background-color:rgba(0,0,0,0.35);background-image:url(<?php echo esc_url( $img_url ); ?>);background-blend-mode:overlay;background-size:cover;background-attachment:fixed;background-position:50% 68%"><!-- wp:blockstrap/blockstrap-widget-container {"pt_lg":"5","pb_lg":"5","sd_shortcode":"[bs_container container='container'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
		<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 pb-5 bg-image-fixed container"><!-- wp:blockstrap/blockstrap-widget-container {"container":"row","pt_lg":"5","pb_lg":"5","flex_align_items_lg":"align-items-lg-center","sd_shortcode":"[bs_container container='row'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col=''  col_md=''  col_lg=''  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(135deg,rgba(6,147,227,1) 0%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='false'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg=''  mb_lg='3'  ml_lg=''  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg='5'  pr_lg=''  pb_lg='5'  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg='align-items-lg-center'  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]","className":"align-items-center"} -->
			<div class="wp-block-blockstrap-blockstrap-widget-container mb-3 pt-5 pb-5 bg-image-fixed row align-items-center"><!-- wp:blockstrap/blockstrap-widget-container {"container":"col","col":"12","col_lg":"8","bg_gradient":"linear-gradient(90deg,rgb(0,252,13) 5%,rgb(155,81,224) 100%)","bg_on_text":true,"mr_lg":"auto","mb_lg":"","ml_lg":"auto","sd_shortcode":"[bs_container container='col'  h100=''  row_cols=''  row_cols_md=''  row_cols_lg=''  col='12'  col_md=''  col_lg='8'  bg=''  bg_color='#0073aa'  bg_gradient='linear-gradient(90deg,rgb(0,252,13) 5%,rgb(155,81,224) 100%)'  bg_image_fixed='false'  bg_image_use_featured='false'  bg_image=''  bg_image_id=''  bg_on_text='true'  text_color=''  text_justify='false'  text_align=''  text_align_md=''  text_align_lg=''  mt=''  mr=''  mb=''  ml=''  mt_md=''  mr_md=''  mb_md=''  ml_md=''  mt_lg=''  mr_lg='auto'  mb_lg=''  ml_lg='auto'  pt=''  pr=''  pb=''  pl=''  pt_md=''  pr_md=''  pb_md=''  pl_md=''  pt_lg=''  pr_lg=''  pb_lg=''  pl_lg=''  border=''  border_type=''  border_width=''  border_opacity=''  rounded=''  rounded_size=''  shadow=''  position=''  sticky_offset_top=''  sticky_offset_bottom=''  display=''  display_md=''  display_lg=''  flex_align_items=''  flex_align_items_md=''  flex_align_items_lg=''  flex_justify_content=''  flex_justify_content_md=''  flex_justify_content_lg=''  flex_align_self=''  flex_align_self_md=''  flex_align_self_lg=''  flex_order=''  flex_order_md=''  flex_order_lg=''  overflow=''  max_height=''  scrollbars=''  hover_animations=''  visibility_conditions=''  anchor=''  css_class='' ]","sd_shortcode_close":"[/bs_container]"} -->
				<div class="wp-block-blockstrap-blockstrap-widget-container me-auto ms-auto col-12 col-lg-8 bg-image-fixed col"><!-- wp:blockstrap/blockstrap-widget-heading {"text":"<?php esc_attr_e('Your Dream Home Starts Here','real-estate-listings'); ?>","html_tag":"h1","text_color":"white","font_size":"display-5","font_weight":"font-weight-bold","text_align_lg":"text-lg-center","bg_gradient":"linear-gradient(139deg,rgb(18,255,1) 4%,rgb(175,236,241) 57%)","bg_on_text":true,"pr_lg":"3","pb_lg":"4","pl_lg":"3","content":""} -->
					<h1 class="wp-block-blockstrap-blockstrap-widget-heading mb-3 pe-3 pb-4 ps-3 text-white text-center font-weight-bold display-5"><?php esc_html_e('Your Dream Home Starts Here','real-estate-listings'); ?></h1>
					<!-- /wp:blockstrap/blockstrap-widget-heading -->

					<!-- wp:geodirectory/geodir-widget-search {"hide_search_input":true,"input_size":"lg","bar_flex_wrap":"flex-wrap","bar_flex_wrap_md":"flex-md-nowrap","bar_flex_wrap_lg":"flex-lg-nowrap","input_border":"0","btn_bg":"primary","btn_rounded_size_md":"circle","btn_rounded_size_lg":"1","bg":"white","mb":"","pt":"2","pr":"1","pb":"2","pl":"2","border":"0","rounded_size":"2","shadow":"shadow","css_class":"opacity-90","content": "","sd_shortcode":"[gd_search hide_search_input='true'  hide_near_input='false'  input_size='lg'  bar_flex_wrap='flex-wrap'  bar_flex_wrap_md='flex-md-nowrap'  bar_flex_wrap_lg='flex-lg-nowrap'  input_border='0'  input_border_opacity=''  input_rounded_size=''  btn_bg='primary'  btn_rounded_size=''  btn_rounded_size_md='circle'  btn_rounded_size_lg='1'  bg='white'  mt=''  mr=''  mb=''  ml=''  pt='2'  pr='1'  pb='2'  pl='2'  border='0'  rounded=''  rounded_size='2'  rounded_size_md=''  rounded_size_lg=''  shadow='shadow'  css_class='opacity-90' ]","className":"rounded-md-pill"} -->
					<div class="wp-block-geodirectory-geodir-widget-search"></div>
					<!-- /wp:geodirectory/geodir-widget-search --></div>
				<!-- /wp:blockstrap/blockstrap-widget-container --></div>
			<!-- /wp:blockstrap/blockstrap-widget-container --></div>
		<!-- /wp:blockstrap/blockstrap-widget-container --></div>
	<!-- /wp:blockstrap/blockstrap-widget-container -->
	<?php

	return ob_get_clean();
}
add_filter( 'blockstrap_pattern_hero_home_default', 'real_estate_theme_pattern_hero_home_default', 15 );
