<?php

update_option('real_estate_directory_install_ocdi_images_sizes_enable', 1);
function ocdi_plugin_intro_text() {
	?>
	<div class="ocdi__intro-text notice notice-warning" style="background: #fefbc1;">
		<p class="about-description" style="margin: 0;padding: 10px 2px;color: #000;font-weight: 500;">
			<?php esc_html_e( "Importing demo data (post, pages, images, theme settings, etc.) is the quickest and easiest way to set up your new theme.", "real-estate-directory" );?><br>
			<?php esc_html_e( "Download our demo content, then follow bellow page 'Manual Demo File Import' and select our XML file.", "real-estate-directory" );?><br><br>
			<a class="button-primary" href="//wpdirectorykit.com/demo_themes/download_theme.php?theme=real-estate-directory" download="filename"><?php esc_html_e( "Download demo content XML file", "real-estate-directory" );?></a>
		</p>
	</div>
	<?php
  }

  add_filter( 'ocdi/plugin_intro_text', 'ocdi_plugin_intro_text' );

  function ocdi_register_plugins( $plugins ) {
	$theme_plugins = [
	  [ // A WordPress.org plugin repository example.
		'name'     => 'Elementor', // Name of the plugin.
		'slug'     => 'elementor', // Plugin slug - the same as on WordPress.org plugin repository.
		'required' => true,                     // If the plugin is required or not.
	  ],
	  [ // A locally theme bundled plugin example.
		'name'     => 'Element Invader',
		'slug'     => 'elementinvader',         // The slug has to match the extracted folder from the zip.
		'required' => true,
	  ],
	];

	$theme_plugins[] = [
		'name'     => 'ElementInvader Addons for Elementor',
		'slug'     => 'elementinvader-addons-for-elementor',         // The slug has to match the extracted folder from the zip.
		'required' => true,
		'preselected' => true,
	];

	$theme_plugins[] = [
		'name'     => 'WP Directory Kit',
		'slug'     => 'wpdirectorykit',  // The slug has to match the extracted folder from the zip.
		'required' => true,
		'preselected' => true,
	];

	return array_merge( $plugins, $theme_plugins );
  }
  add_filter( 'ocdi/register_plugins', 'ocdi_register_plugins' );

 /* after import */
function ocdi_after_import_setup($selected_import) {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
 
    set_theme_mod( 'nav_menu_locations', array(
            'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
	));

	$main_menu = get_term_by( 'Menu 1', 'Main Menu', 'nav_menu', 'Menu 1' );

	if(!$main_menu) {
		$main_menu = wp_get_nav_menu_object("Menu 1" );
		set_theme_mod( 'nav_menu_locations', array(
			'main-menu' => $main_menu->term_id,
			'main_menu' => $main_menu->term_id,
		));
	}

	// Assign front page and posts page (blog page).
	if(!function_exists('wdk_page_by_title')) {
        return false;
    }

	// Assign front page and posts page (blog page).
	$front_page_id = wdk_page_by_title( 'Homepage' );
	$listing_page_id  = wdk_page_by_title( 'Listing Preview' );
	$results_page_id  = wdk_page_by_title( 'Results Listings' );
	$page_for_posts_id = wdk_page_by_title( 'Blog' );
	$home_alt_page = wdk_page_by_title( 'Home Alt' );
 
    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $page_for_posts_id->ID );
	
	if($listing_page_id)
		update_option( 'wdk_listing_page', $listing_page_id->ID, TRUE);
	
	if($results_page_id)
		update_option( 'wdk_results_page', $results_page_id->ID, TRUE);

	/* remove default post */
		
	$post_default= wdk_page_by_title('Hello world!', OBJECT, 'post');
	if($post_default)
		wp_delete_post(  $post_default->ID, true );

	/* import wdk content */
	$WMVC = &wdk_get_instance();

	//$_GET['multipurpose'] = 'car-dealer.xml';

	$WMVC->load_controller('wdk_settings','_api_import');

	/* udpate posts */	
	$posts = get_posts( array(
		'numberposts'=> 5,
		'orderby'   => 'id',
		'order'      => 'ASC',
		'post_type'  => 'post',
	));

	$date = date('Y-m-d H:i:s');
	foreach($posts as $post) {
		$post_udpate = array();
		$post_udpate['ID'] = $post->ID;
		$post_udpate['post_date'] = $date;
		$post_udpate['post_date_gmt'] = $date;
		$post_udpate['post_modified'] = $date;
		$post_udpate['post_modified_gmt'] = $date;
		wp_update_post($post_udpate );
	}

	/* replace content links in footer menu */
	if ( true) {
		if($results_page_id) {
			$from = get_site_url().'/grid-map/?is_featured=on#results';
			$to = real_estate_directory_url_suffix(get_permalink($results_page_id), 'is_featured=on#results');
			real_estate_directory_replace_links($from, $to);
		}
		
		if($page_for_posts_id) {
			$from = get_site_url().'/blog/';
			$to = get_permalink($page_for_posts_id);
			real_estate_directory_replace_links($from, $to);
		}

		if($home_alt_page) {
			$from = get_site_url().'/home-alt/';
			$to = get_permalink($home_alt_page);
			real_estate_directory_replace_links($from, $to);
		}


		$menu_obj = wp_get_nav_menu_object('menu-2');
		$menu_id  = $menu_obj ? $menu_obj->term_id : 0;

	
		if($menu_id && $results_page_id) {

			$itemData =  array(
				'menu-item-url' =>  real_estate_directory_url_suffix(get_permalink($results_page_id), 'is_featured=on#results'),
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4421, $itemData, 'Featured');

			$itemData =  array(
				'menu-item-url' => real_estate_directory_url_suffix(get_permalink($results_page_id), 'search_category=1#results'),
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4422, $itemData, 'Houses');

			$itemData =  array(
				'menu-item-url' =>  real_estate_directory_url_suffix(get_permalink($results_page_id), 'search_category=4#results')
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4423, $itemData, 'Commercial');
		}

		$menu_obj = wp_get_nav_menu_object('mobile-menu');
		$menu_id  = $menu_obj ? $menu_obj->term_id : 0;
	
		if($menu_id && $results_page_id) {

			$itemData =  array(
				'menu-item-url' =>  real_estate_directory_url_suffix(get_permalink($results_page_id), 'is_featured=on#results'),
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4046, $itemData, 'Featured');

			$itemData =  array(
				'menu-item-url' => real_estate_directory_url_suffix(get_permalink($results_page_id), 'search_category=1#results'),
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4047, $itemData, 'Houses');

			$itemData =  array(
				'menu-item-url' =>  real_estate_directory_url_suffix(get_permalink($results_page_id), 'search_category=4#results')
			);
			real_estate_directory_update_nav_menu_item($menu_id, 4048, $itemData, 'Commercial');
		}
    }

	/* Replace Links */
	/* login */
		
	$from = 'https://www.wpdirectorykit.com/nexproperty/wp-admin/admin.php?page=wdk_listing';
	$to = get_admin_url();
	real_estate_directory_replace_links($from, $to);

	$from = 'https://www.wpdirectorykit.com/nexproperty/wp-admin/';
	$to = get_admin_url();
	real_estate_directory_replace_links($from, $to);

	$from = 'https://www.wpdirectorykit.com/nexproperty/index.php/login/';
	$to = get_admin_url();
	real_estate_directory_replace_links($from, $to);
	
	$from = 'https://www.wpdirectorykit.com/nexproperty';
	$to = get_home_url();
	real_estate_directory_replace_links($from, $to);
	
	/* homepage */
	$from = 'home_page_link_replace';
	$to = get_home_url();
	real_estate_directory_replace_links($from, $to);
	
	/* homepage */
	$from = '2020';
	$to = date('Y');
	real_estate_directory_replace_links($from, $to);
	$from = '2021';
	real_estate_directory_replace_links($from, $to);
	
	/* wdk_listing_preview_feature_category */
	$from = 'wdk_listing_preview_feature_category';
	$to = 26;
	real_estate_directory_replace_links($from, $to);
	                
    if(!file_exists(get_stylesheet_directory() .'/includes/theme-help/links.php')) {
        $from = '\'https://wpdirectorykit.com/\'';
        real_estate_directory_replace_links($from, '#');

        $from = 'WpDirectoryKit.com';
        real_estate_directory_replace_links($from, 'WpDirectoryKit');

        $from = '©';
        real_estate_directory_replace_links($from, '');

        $from = '"https://wpdirectorykit.com/"';
        real_estate_directory_replace_links($from, '#');
    }

	/* homepage */
	/*
		$from = 'Properties';
		$to = 'Cars';
		real_estate_directory_replace_links($from, $to);
		$from = 'Popular House Types';
		$to = 'Popular Car Types';
		real_estate_directory_replace_links($from, $to);
		$from = 'House';
		$to = 'Car';
		real_estate_directory_replace_links($from, $to);
		$from = 'Add Property'; 
		$to = 'Add Car';
		real_estate_directory_replace_links($from, $to);
	*/
	/* custom_logo */
	if(function_exists('wmvc_add_wp_image')) {
		$custom_logo_id = wmvc_add_wp_image(get_stylesheet_directory() .'/assets/images/logo1.png');
		set_theme_mod( 'custom_logo', $custom_logo_id );

    	set_theme_mod( 'footer_logo', get_stylesheet_directory_uri() .'/assets/images/logo5.png');
    	set_theme_mod( 'footer_logo', get_stylesheet_directory_uri() .'/assets/images/logo5.png');
				
		$custom_logo_id = wmvc_add_wp_image(get_stylesheet_directory() .'/assets/images/fav.jpg');
		update_option( 'site_icon', $custom_logo_id );
	}

	set_theme_mod( 'footer_content', esc_html__('Aenean sollicitudin, lorem quis bibend auctor, nisi elit consequat ipsum, necittis sem nibh id elit. Duis sed odio enim.', 'real-estate-directory') );
	set_theme_mod( 'footer_phone_number', '(917) 382-2057' );
	set_theme_mod( 'footer_email_address', 'agent@example.com' );
	set_theme_mod( 'footer_copyright_text', 'Copyright © '.date('Y').' Realtor Directory Moison' );

	/* sidebar */
	if(true){
		/* clear */
		$sidebars_widgets = get_option( 'sidebars_widgets' );
		$sidebars_widgets['sidebar-1'] = array();
		update_option('sidebars_widgets', $sidebars_widgets); //update sidebars
		
		real_estate_directory_insert_widget('sidebar-1', 'search');
		real_estate_directory_insert_widget('sidebar-1', 'recent-posts');
		real_estate_directory_insert_widget('sidebar-1', 'categories');

		/* clear */
		$sidebars_widgets = get_option( 'sidebars_widgets' );
		$sidebars_widgets['sidebar'] = array();
		update_option('sidebars_widgets', $sidebars_widgets); //update sidebars
		
		real_estate_directory_insert_widget('sidebar', 'search');
		real_estate_directory_insert_widget('sidebar', 'recent-posts');
		real_estate_directory_insert_widget('sidebar', 'categories');

		/* clear */
		$sidebars_widgets = get_option( 'sidebars_widgets' );
		$sidebars_widgets['footer'] = array();
		update_option('sidebars_widgets', $sidebars_widgets); //update sidebars
		
		real_estate_directory_insert_widget('footer', 'text', array('title' => esc_html__('Information', 'real-estate-directory'), 'text'=>'<ul class="footer-list-items">
																								<li class="list-item">
																						<a href="tel:(917) 382-2057">
																						<i class="fas fa-phone"></i>
																						(917) 382-2057								</a>
																						</li>
																						<li class="list-item">
																						<a href="mailto:agent@example.com">
																						<i class="fas fa-envelope"></i>
																						agent@example.com								
																						</a>
																						</li>
																						<li class="list-item">
																						<i class="far fa-clock"></i>
																						10AM - 9PM					
																						</li>
																						</ul>'));
		real_estate_directory_insert_widget('footer', 'recent-posts');
		real_estate_directory_insert_widget('footer', 'text', array('title' => '', 'text'=>'<nav class="footer-social"><a class="social_link" href="#" target="_blank"><i class="fa fa-facebook-f"></i></a><a class="social_link" href="#" target="_blank"><i class="fab fa-twitter"></i></a>
																				<a class="social_link" href="#" target="_blank"><i class="fab fa-instagram"></i></a></nav>'));
	}

	/* header buttons */
	if(true){
		set_theme_mod('show_sign_in_button','yes');
		set_theme_mod('show_property_button','yes');
		set_theme_mod('sign_in_button_text', esc_html__('Login', 'real-estate-directory'));

		set_theme_mod('property_button_text', esc_html__('Add Listing', 'real-estate-directory'));
	}
	update_option('real_estate_directory_install_ocdi_images_sizes_enable', 0);
	update_option('wdk_theme_rdm_installed', 1);

}  
if ( ! function_exists('real_estate_directory_replace_links'))
{

function real_estate_directory_replace_links($from = '', $to = '') {
	global $wpdb;
	// @codingStandardsIgnoreStart cannot use `$wpdb->prepare` because it remove's the backslashes
	$rows_affected = $wpdb->query(
		"UPDATE {$wpdb->postmeta} " .
		"SET `meta_value` = REPLACE(`meta_value`, '" . str_replace( '/', '\\\/', $from ) . "', '" . str_replace( '/', '\\\/', $to ) . "') " .
		"WHERE `meta_key` = '_elementor_data' AND `meta_value` LIKE '[%' ;" );
	/* end login */
	
}
}
add_action( 'ocdi/after_import', 'ocdi_after_import_setup' );

if(!function_exists('real_estate_directory_insert_widget'))
{
    function real_estate_directory_insert_widget($sidebar_id, $widget_name, $widget_options_new = array())
    {
        static $sidebar_cleared = array();
        
        static $widgets_array = array();
        $id = 1;
        
        if(isset($widgets_array[$widget_name])) {
            $widgets_array[$widget_name]++;
            $id = $widgets_array[$widget_name];
        } else {
            $widgets_array[$widget_name] = $id;
        }
        
        $sidebars_widgets = get_option( 'sidebars_widgets' );
        /* set teme mod */ 
        
        $widget_options = get_option('widget_'.$widget_name);
        if(empty($widget_options)) {
			$widget_options = array('_multiwidget'=>1);
		}
        $widget_options[$id] = array('title'=>'');
        
        $widget_options[$id] = $widget_options_new;
        
        
        // [Check and skip import if found]
        $skip_widget_import = false;
        if(isset($sidebars_widgets[$sidebar_id]))
        foreach($sidebars_widgets[$sidebar_id] as $val)
        {
            if(strpos($val, $widget_name) !== false)
                $skip_widget_import = true;
        }
        if(false && $skip_widget_import)
        {
            return FALSE;
        }
        // [/Check and skip import if found]

        if(isset($sidebars_widgets[$sidebar_id]) && !in_array($widget_name.'-'.$id, $sidebars_widgets[$sidebar_id])) { //check if sidebar exists and it is empty
            
            if(empty($sidebars_widgets[$sidebar_id]))
            {
                $sidebars_widgets[$sidebar_id] = array($widget_name.'-'.$id); //add a widget to sidebar
            }
            else
            {
                $sidebars_widgets[$sidebar_id][] = $widget_name.'-'.$id;
            }

            update_option('widget_'.$widget_name, $widget_options); //update widget default options
            update_option('sidebars_widgets', $sidebars_widgets); //update sidebars
        }
        else // if sidebar doesn't exists'
        {
            $sidebars_widgets[$sidebar_id] = array($widget_name.'-'.$id); //add a widget to sidebar
            $sidebars_widgets[$sidebar_id][] = $widget_name.'-'.$id;

            update_option('widget_'.$widget_name, $widget_options); //update widget default options
            update_option('sidebars_widgets', $sidebars_widgets); //update sidebars
        }

        
        return TRUE;
    }
}


if ( ! function_exists('real_estate_directory_url_suffix'))
{
	function real_estate_directory_url_suffix($base_url, $extension_url="")
	{
        if(strpos($base_url,'?') !== FALSE){
            $base_url .='&';
        } else {
            $base_url .='?';
        }
        return  $base_url.$extension_url;
	}
}

if ( ! function_exists('real_estate_directory_update_nav_menu_item'))
{

    function real_estate_directory_update_nav_menu_item($menu_id, $item_id, $itemData = array(), $check_title= '') {

        $post = get_post( $item_id );
		$menu_item_obj = wp_setup_nav_menu_item( $post );

		// Need to persist the menu item data. See https://core.trac.wordpress.org/ticket/28138
		if ( ! is_wp_error( $menu_item_obj ) && (empty($check_title) || $menu_item_obj->title == $check_title)) {
			// Correct the menu position if this was the first item. See https://core.trac.wordpress.org/ticket/28140
			$position = ( 0 === $menu_item_obj->menu_order ) ? 1 : $menu_item_obj->menu_order;

			$prepared_nav_item = array(
				'menu-item-db-id'       => $item_id,
				'menu-item-object-id'   => $menu_item_obj->object_id,
				'menu-item-object'      => $menu_item_obj->object,
				'menu-item-parent-id'   => $menu_item_obj->menu_item_parent,
				'menu-item-position'    => $position,
				'menu-item-type'        => $menu_item_obj->type,
				'menu-item-title'       => $menu_item_obj->title,
				'menu-item-url'         => $menu_item_obj->url,
				'menu-item-description' => $menu_item_obj->description,
				'menu-item-attr-title'  => $menu_item_obj->attr_title,
				'menu-item-target'      => $menu_item_obj->target,
				// Stored in the database as a string.
				'menu-item-status'      => $menu_item_obj->post_status,
				'menu-id'               => $menu_id,
			);

            $itemData = array_merge( $prepared_nav_item,$itemData);
            wp_update_nav_menu_item($menu_id, $item_id, $itemData);

		} else {

		}
	}
}