<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package NexProperty
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php
    if(function_exists('w-body_open')){
        wp_body_open();
    } else {
        do_action('wp_body_open');
    }
    ?>
	<div class="mob_nav_mask"></div>
	<div class="wrapper">
        <a class="skip-link screen-reader-text" href="#content"><?php echo esc_html__( 'Skip to content', 'real-estate-directory' ); ?></a>
		<header>
			<div class="top-bar">
				<div class="container">
					<div class="row">
						<div class="col-lg-6 col-md-6 col-sm-6 col-6">
							<span class='h-text'><?php echo esc_html(get_bloginfo('description'));?></span>
						</div>
						<div class="col-lg-6 col-md-6 col-sm-6 col-6">
							<div class="log-details">
								
								<?php if( get_theme_mod( 'show_sign_in_button' ) == 'yes' || get_theme_mod( 'show_property_button' ) == 'yes' ) : ?>
									<div class="sign-in-pr">
										<ul class="sign">
											<?php if( get_theme_mod( 'show_sign_in_button' ) == 'yes' ) : ?>
												<?php if (!is_user_logged_in()): ?>
													<li><a href="<?php echo esc_url(wp_login_url());?>" class="sign_in"><i class="fa fa-user" aria-hidden="true"></i><?php echo esc_html( get_theme_mod( 'sign_in_button_text' ) ); ?></a></li>
												<?php else:?>
													<li><a href="<?php echo esc_url(wp_logout_url( get_permalink() )); ?>" class="sign_in" title="<?php echo esc_attr__('Log Out','real-estate-directory' ); ?>"><i class="fa fa-user" aria-hidden="true"></i><?php echo esc_html__('Logout','real-estate-directory' ); ?></a></li>
													<li>
														<?php
															$dash_url = get_admin_url() . "admin.php?page=wdk";
															if(function_exists('wdk_dash_url') && get_option('wdk_membership_dash_page') &&  wdk_dash_url()){
																$dash_url = wdk_dash_url();
															} 
														?>
														<a href="<?php echo esc_url($dash_url);?>" class="sign_in" title="<?php echo esc_attr__('Dash','real-estate-directory' ); ?>" class="wdk-element-button logout">
															<i aria-hidden="true" class="fas fa-tachometer-alt"></i>                           
														</a>
													</li>
												<?php endif;?>
											<?php endif; ?>
										</ul>
									</div><!--sign-in-pr end-->
								<?php endif; ?>

								<?php if (get_theme_mod('moison_login_enabled') && get_theme_mod('moison_login_enabled') == 1): ?>
									<?php if (!is_user_logged_in()): ?>
										<span class="login-form">
											<a href="<?php echo esc_url(wp_login_url());?>" class="<?php if (!is_user_logged_in()): ?> login_popup_enabled <?php endif; ?>">
												<i class="la la-user"></i> <b><?php echo esc_html__('Login','real-estate-directory');?></b> 
											</a>
												/ 
											<a href="<?php echo esc_url(wp_login_url());?>#sw_register">
												<b><?php echo esc_html__('Register','real-estate-directory');?></b>
											</a>
										</span>
									<?php else: ?>
										<a href="<?php echo esc_url( wp_logout_url( get_permalink() ) ); ?>" class=""><span class="login-form"><i class="la la-user"></i> <b><?php echo esc_html__('Log out','real-estate-directory');?></b></span></a>
									<?php endif; ?>
								<?php endif;?>
							</div><!--log-details end-->
						</div>
					</div>
				</div>
			</div><!--top-bar end-->
			<div class="container header-main">
				<div class="navigation text-right">
					<?php echo wp_nav_menu( array(
						'menu'  => 'Menu 2',
						'container'       => 'nav',
						'container_class' => 'menu-menu-1-container theme-menu',
						'container_id'    => '',
						'menu_class'      => 'menu',
						'menu_id'         => '',
						'echo'            => true,
						'fallback_cb'     => '__return_false',
						'before'          => '',
						'after'           => '',
						'link_before'     => '',
						'link_after'      => '',
						'items_wrap'      => '<ul id = "%1$s" class = "%2$s">%3$s</ul>',
												'theme_location' => is_user_logged_in() ? 'main_menu' : 'main_menu',
						'depth'           => 0,
					) ); ?>
				</div><!--navigation end-->
				<div class="logo text-center">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php esc_attr(bloginfo( 'name' )); ?>">
						<?php if(( nexproperty_custom_logo() ) ) : ?>
							<img src="<?php echo esc_url( nexproperty_custom_logo()); ?>" alt="<?php echo esc_attr__('logo','real-estate-directory'); ?>">
						<?php else: ?>
							<span class="logo-text">
								<?php echo esc_html( get_bloginfo( 'name' ) ); ?>
							</span>
						<?php endif; ?>
					</a>
				</div>
				<div class="navigation text-left">
					<?php echo wp_nav_menu( array(
						'menu'  => 'Menu 1',
						'container'       => 'nav',
						'container_class' => 'menu-menu-1-container theme-menu',
						'container_id'    => '',
						'menu_class'      => 'menu',
						'menu_id'         => '',
						'echo'            => true,
						'fallback_cb'     => '__return_false',
						'before'          => '',
						'after'           => '',
						'link_before'     => '',
						'link_after'      => '',
						'items_wrap'      => '<ul id = "%1$s" class = "%2$s">%3$s</ul>',
												'theme_location' => is_user_logged_in() ? 'main_menu' : 'main_menu',
						'depth'           => 0,
					) ); ?>

					<a href="#test1" aria-expanded="false" data-set-focus=".close-nav-toggle" title="<?php echo esc_attr__( 'Mobile Menu' ,'real-estate-directory'); ?>" class="menu-btn <?php if( get_theme_mod( 'show_sign_in_button' ) != 'yes' && get_theme_mod( 'show_property_button' ) != 'yes' ) : ?> md-right <?php endif;?>">
						<i class="fa fa-bars"></i>
					</a>
				</div><!--navigation end-->
			</div>
		</header><!--header end-->
		<div class="clearfix"></div>
<?php echo wp_nav_menu( array(
	'menu'  => 'Main Menu',
	'container'       => 'div',
	'container_class' => 'mobile-menu',
	'container_id'    => '',
	'menu_class'      => 'menu',
	'menu_id'         => '',
	'echo'            => true,
	'fallback_cb'     => '__return_false',
	'before'          => '',
	'after'           => '',
	'link_before'     => '',
	'link_after'      => '',
					'theme_location' => is_user_logged_in() ? 'main_menu' : 'main_menu',
	'items_wrap'      => '<div><ul id = "%1$s" class = "%2$s">%3$s</ul></div>',
	'depth'           => 0,
) ); ?>