<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

$style_demo = get_theme_mod( 'pointify_demo_selection', '' );
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="post-main-section">	
		<?php 
			pointify_post_thumbnail(); 
			pointify_get_the_category();
		?>
		<div class="post-content-section">
			<?php if($style_demo === 'business') { ?>
				<div class="post-author-sec">
					<?php pointify_author_details(); ?>
				</div>
			<?php } ?>
			<div class="post-details-section">
				<?php if($style_demo === 'business') { ?>
					<div class="post-details-info-sec">
						<div class="post-time-info">
							<?php pointify_post_time_details(); ?>
						</div>
						<div class="post-other-info">
							<span class="post-comment-count"><?php comments_number( '0', '1', '%' ); ?></span>
						</div>
						<div class="post-share-section">
							<?php pointify_post_share(); ?>
						</div>
					</div>
				<?php } ?>
				<div class="post-detail-content-sec">
					<?php 
						the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' ); 
						if($style_demo === 'job_board' || $style_demo === 'lawyer' ) { ?>
						<div class="post-details-info-sec">
							<p class="author-name"><?php echo get_the_author_meta('display_name'); ?></p>
							<div class="post-time-info">
								<?php pointify_post_time_details(); ?>
							</div>
						</div>
					<?php }
						if ( has_excerpt() ) {
							the_excerpt();
						}
					?>
					<a class="more-link" href="<?php echo get_permalink(); ?>" title="<?php echo get_the_title(); ?>">Read More</a>
				</div>

			</div>
		</div>
	</div><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->
