/**
 * Widget Media (Admin).
 *
 * @since 1.0
 */

function openMediaUploader(button) {
	var fieldId = button.previousElementSibling.id;
	var frame;
	if (frame) {
		frame.open();
		return;
	}
	frame = wp.media({
		title: 'Select Image',
		button: { text: 'Select' },
		multiple: false
	});
	frame.on('select', function () {
		var attachment = frame.state().get('selection').first().toJSON();
		document.getElementById(fieldId).value = attachment.url;
		jQuery( this ).siblings( 'input[type="text"]' ).trigger( 'change' ); 
	});
	frame.open();
}
// Clear input.
jQuery(document).ready(function() {         
	jQuery(".pointify-widget-media-clear").click(function(){
		jQuery( this ).siblings( 'input[type="text"]' ).val( '' ).trigger( 'change' ); 
	});
});