<?php
/**
 * Job Listing Content
 *
 * @package Pointify
 * @since 1.0.0
 * @version 1.0.0
 */

$job_listing_id = get_the_ID();
$geolocation_lat = get_post_meta( $job_listing_id, 'geolocation_lat', true );
$geolocation_long = get_post_meta( $job_listing_id, 'geolocation_long', true );

// $featured_image = get_post_meta( $job_listing_id );

// echo '<pre>';
// print_r ($featured_image);
// echo '</pre>';

?>

<li id="job_listing-<?php the_ID(); ?>" <?php if($geolocation_lat) { ?> data-latitude="<?php echo $geolocation_lat;  ?>" <?php } if($geolocation_lat) { ?> data-longitude="<?php echo $geolocation_long;  ?>" <?php } ?>class="job-listing job_listing job_board_main_list">
    <div class="content-box">
        <div class="job_board_list">
            <?php
                $job_title = get_the_title( $job_listing_id );
                $job_location = get_post_meta( $job_listing_id, '_job_location', true );
                $job_types = wp_get_post_terms($job_listing_id, 'job_listing_type');

            ?>
            <div class="feature-image-section">
                <?php 
                    if ( has_post_thumbnail() ) {
                ?>
                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
                <?php } else {
                    ?>
                    <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                    <?php
                } ?>
            </div>

            <div class="job-listing-details">
                <?php if(!empty($job_title)) { ?>
                    <div class="job-title">
                        <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                    </div>
                <?php } 
                    if (!empty($job_types) && !is_wp_error($job_types)) {
                        $job_type = $job_types[0]; ?>
                    <span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
                <?php        
                    }
                if (class_exists('Astoundify\Favorites\Favorite')) {
                ?>
                    <div class="listing_fav_sec">
                        <?php echo astoundify_favorites_link($job_listing_id); ?>	
                    </div>
                <?php } ?>
            </div>
            <?php
            if(class_exists('WP_Job_Manager_Reviews')) { ?>
                <div class="listing_review_cls">
                    <?php
                        echo wpjmr_reviews_get_stars($job_listing_id);
                        echo wpjmr_get_reviews_average($job_listing_id);
                    ?>
                </div>
            <?php
                }
                if(!empty($job_location)){
                    ?>
                    <div class="job-location">
                        <span><?php echo $job_location; ?></span>
                    </div>
                <?php }  ?>
        </div>

        <div class="job-bottom-content">
           
            <div class="job-single-btn-cls">
                <a href="<?php echo esc_url( get_permalink() ); ?>"><?php _e('Contact Now', 'pointify'); ?></a>
            </div>
        </div>

    </div>   
</li>