<?php
/**
 * Job Listing Content
 *
 * @package Pointify
 * @since 1.0.0
 * @version 1.0.0
 */

$job_listing_id = get_the_ID();
$geolocation_lat = get_post_meta( $job_listing_id, 'geolocation_lat', true );
$geolocation_long = get_post_meta( $job_listing_id, 'geolocation_long', true );

// $featured_image = get_post_meta( $job_listing_id );

// echo '<pre>';
// print_r ($featured_image);
// echo '</pre>';

?>

<li id="job_listing-<?php the_ID(); ?>" <?php if($geolocation_lat) { ?> data-latitude="<?php echo $geolocation_lat;  ?>" <?php } if($geolocation_lat) { ?> data-longitude="<?php echo $geolocation_long;  ?>" <?php } ?>class="job-listing job_listing job_board_main_list">
    <div class="content-box">
        <div class="job_board_list">
            <?php
                $job_title = get_the_title( $job_listing_id );
                $job_salary = get_post_meta( $job_listing_id, '_job_salary', true );
                $job_salary_currency = get_post_meta( $job_listing_id, '_job_salary_currency', true );
                
                $job_types = wp_get_post_terms($job_listing_id, 'job_listing_type');

                $job_post_date = get_post_field('post_date', $job_listing_id);
                $timestamp = strtotime($job_post_date);
                $formatted_date = date_i18n('d M Y', $timestamp);

            ?>
            <div class="feature-image-section">
                <?php 
                    if ( has_post_thumbnail() ) {
                ?>
                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
                <?php } else {
                    ?>
                    <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                    <?php
                } ?>
            </div>

            <div class="job-listing-details">
                <?php 
                    if (!empty($job_types) && !is_wp_error($job_types)) {
                        $job_type = $job_types[0]; ?>
                    <span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
                <?php        
                    }
                ?>
                <?php if(!empty($job_title)) { ?>
                    <div class="job-title">
                        <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                    </div>
                <?php } ?>
                <span class="job-publish-cls"><?php echo $formatted_date; ?></span>
            </div>
        </div>

        <?php 
            $job_salary_unit = get_post_meta( $job_listing_id, '_job_salary_unit', true );
            $job_salary_unit_capitalized = strtolower($job_salary_unit);
        ?>
        <div class="job-bottom-content">
            <?php
                if(!empty($job_salary)) { ?>
                    <div class="listing-pricing">
                        <h4><?php echo $job_salary_unit_capitalized . ' ' . __('Package', 'pointify'); ?></h4>
                        <h5><?php echo $job_salary_currency .' '. $job_salary; ?></h5>
                    </div>
                <?php }
            ?>
            <div class="job-single-btn-cls">
                <a href="<?php echo esc_url( get_permalink() ); ?>"><?php _e('Apply Now', 'pointify'); ?></a>
            </div>
        </div>

    </div>   
</li>