<?php
/**
 * Job Listing Content
 *
 * @package Pointify
 * @since 1.0.0
 * @version 1.0.0
 */

$job_listing_id = get_the_ID();
$geolocation_lat = get_post_meta( $job_listing_id, 'geolocation_lat', true );
$geolocation_long = get_post_meta( $job_listing_id, 'geolocation_long', true );

?>

<li id="job_listing-<?php the_ID(); ?>" <?php if($geolocation_lat) { ?> data-latitude="<?php echo $geolocation_lat;  ?>" <?php } if($geolocation_lat) { ?> data-longitude="<?php echo $geolocation_long;  ?>" <?php } ?>class="job-listing job_listing">
    <div class="content-box">
        <?php
            $job_title = get_the_title( $job_listing_id );
            $featured_image = get_post_meta( $job_listing_id, '_featured_image', true );
            $job_location = get_post_meta( $job_listing_id, '_job_location', true );
            $job_salary = get_post_meta( $job_listing_id, '_job_salary', true );
			$job_salary_currency = get_post_meta( $job_listing_id, '_job_salary_currency', true );
        ?>
        <div class="feature-image-section">
            <?php if(!empty($job_salary)) { ?>
                <div class="listing-pricing">
                    <h5><?php echo $job_salary_currency .' '. $job_salary; ?></h5>
                </div>
            <?php }
             if($featured_image) { ?>
                <img src="<?php echo $featured_image; ?>" alt="<?php echo $job_title; ?>-img" class="feature-img">
            <?php } else {
                ?>
                <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="feature-img">
                <?php
            } 
            if ( has_post_thumbnail() ) {
            ?>
                <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
            <?php } else {
                ?>
                <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                <?php
            } ?>
        </div>

        <div class="job-listing-details">
            <?php if(!empty($job_title)) { ?>
                <div class="job-title">
                    <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                </div>
            <?php }   
				if(!empty($job_location)){
			?>
                    <div class="job-location">
                        <span><?php echo $job_location; ?></span>
                    </div>
            <?php } ?>
        </div>

        <div class="listing_review_fav">
            <?php if ( is_position_filled() ) { ?>
				<span class="position-filled closed"><?php _e( 'Closed', 'pointify' ); ?></span> 
            <?php } else { ?>
                    <span class="position-filled open"><?php _e( 'Open', 'pointify' ); ?></span> 
            <?php }
                if(class_exists('WP_Job_Manager_Reviews')) { ?>
                <div class="listing_review_cls">
                    <?php
                        echo wpjmr_reviews_get_stars($job_listing_id);
                        echo wpjmr_get_reviews_average($job_listing_id);
                    ?>
                </div>
            <?php
                }
                if (class_exists('Astoundify\Favorites\Favorite')) {
            ?>
                <div class="listing_fav_sec">
                    <?php echo astoundify_favorites_link($job_listing_id); ?>	
                </div>
            <?php } ?>
        </div>

    </div>   
</li>