<?php
/**
 * Job Filters Flat
 *
 * @package pointify
 * @since 1.0.0
 */

$atts = apply_filters( 'job_manager_ouput_jobs_default', array(
	'per_page' => get_option( 'job_manager_per_page' ),
	'orderby' => 'featured',
	'order' => 'DESC',
	'show_categories' => true,
	'categories' => true,
	'selected_category' => false,
	'job_types' => false,
	'location' => false,
	'keywords' => false,
	'selected_job_types' => false,
	'show_category_multiselect' => false,
	'selected_region' => false,
) );

global $is_flat;

do_action( 'job_manager_job_filters_before', $atts ); ?>

<form class="job_search_form<?php if ( $is_flat ) : ?> job_search_form--flat<?php endif; ?>" action="<?php echo pointify_get_listing_page_permalink() ? pointify_get_listing_page_permalink() : get_post_type_archive_link( 'job_listing' ); ?>" method="GET">
	<?php do_action( 'job_manager_job_filters_start', $atts ); ?>

	<div class="search_jobs">
		<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>

		<div class="search_keywords">
			<label for="search_keywords"><?php _e( 'Keywords', 'pointify' ); ?></label>
			<input type="text" name="search_keywords" id="search_keywords" placeholder="<?php esc_attr_e( 'Keywords', 'pointify' ); ?>" />
		</div>

		<div class="search_location">
			<label for="search_location"><?php _e( 'Location', 'pointify' ); ?></label>
			<input type="text" name="search_location" id="search_location" placeholder="<?php esc_attr_e( 'Location', 'pointify' ); ?>" />
		</div>

		<?php if ( get_option( 'job_manager_enable_categories' ) ) : ?>

		<div class="search_categories search_category_dropdown">
			<label for="search_categories"><?php _e( 'Category', 'pointify' ); ?></label>
			<select class="search_category" id="search_category_dropdown" name="search_category">
				<option value=""><?php echo _e( 'Choose a category…', 'pointify' ); ?></option>
				<?php 
				$termsFilter = get_terms('job_listing_category');
				if(!empty($termsFilter)) :
					foreach ( $termsFilter as $termsFilterValue ) : ?>
						<option class="level-0" value="<?php echo esc_attr( $termsFilterValue->term_id ); ?>"><?php echo esc_html( $termsFilterValue->name ); ?></option>
				<?php endforeach; 
				endif;
				?>
			</select>
		</div>

		<?php endif;

		/**
		 * Show the submit button on the job filters form.
		 *
		 * @since 1.0
		 *
		 * @param bool $show_submit_button Whether to show the button. Defaults to true.
		 * @return bool
		 */

		if ( apply_filters( 'job_manager_job_filters_show_submit_button', true ) ) : ?>
			<div class="search_submit">
				<input type="submit" value="<?php esc_attr_e( 'Search Jobs', 'pointify' ); ?>">
			</div>
		<?php endif;

		do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>
	</div>

	<?php //do_action( 'job_manager_job_filters_end', $atts ); ?>
</form>

<?php do_action( 'job_manager_job_filters_after', $atts ); ?>
