<?php
/*Pointify-User-Widget*/
class Pointify_User_Carousel_Widget extends WP_Widget {
    public function __construct() {
        parent::__construct(
            'pointify_user_carousel_widget',
            __('Pointify - User Carousel Widget', 'pointify'),
            array('description' => __('A widget to display a carousel of specified user images with names', 'pointify'))
        );
    }

    public function widget($args, $instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
        echo $args['before_widget'];

        // Widget content goes here
        $user_ids = !empty($instance['user_ids']) ? explode(',', $instance['user_ids']) : array();

		if(!empty($title)){ ?>
			<div class="user_title">
				<h2 class="widget-title"><?php echo $title; ?></h2>
			</div><?php
		}
        $this->display_user_carousel($user_ids);

        echo $args['after_widget'];
    }

    private function display_user_carousel($user_ids) {
        // Output carousel HTML
        echo '<div id="user-carousel" class="owl-carousel">';
		
		if (count($user_ids) === 0) {
			$args = array('orderby' => 'display_name');
			$wp_user_query = new WP_User_Query($args);
			$authors = $wp_user_query->get_results();
			
			if (!empty($authors)) {				
				foreach ($authors as $author) {
					
					$user = get_user_by('ID', $author->ID);
					$custom_width = 400; 
				
					if ($user) {
						$user_avatar = get_avatar_url($author->ID, array('size' => $custom_width));
						$user_name = $user->display_name;
						$user_roles = $user->roles;

						echo '<div class="user-slide">';
						echo '<img src="' . esc_url($user_avatar) . '" width="' . esc_attr($custom_width) . '" alt="' . esc_attr($user_name) . '" />';
						echo '<p class="admin-name">' . esc_html($user_name) . '</p>';
						 // Display user roles
						if (!empty($user_roles)) {
							echo '<p class="roles-name">'. esc_html(implode( $user_roles)) . '</p>';
						}
						
						$facebook = get_user_meta($author->ID, 'facebook', true);
						$twitter = get_user_meta($author->ID, 'twitter', true);
						$instagram = get_user_meta($author->ID, 'instagram', true);
						$youtube = get_user_meta($author->ID, 'youtube', true);

						if ($facebook || $twitter || $instagram) {
							echo '<ul>';

							if ($facebook) {
								echo '<li><a href="' . esc_url($facebook) . '" title="'.esc_attr( 'facebook', 'pointify').'">';
									pointify_instagram_icons();
								echo '	</a></li>';
							}

							if ($twitter) {
								echo '<li><a href="' . esc_url($twitter) . '" title="'.esc_attr( 'twitter', 'pointify').'">';
									pointify_twitter_icons();
								echo '</a></li>';
							}

							if ($instagram) {
								echo '<li><a href="' . esc_url($instagram) . '" title="'.esc_attr( 'instagram', 'pointify').'">';
									pointify_facebook_icons();
								echo '</a></li>';
							}
							if ($youtube) {
								echo '<li><a href="' . esc_url($youtube) . '" title="'.esc_attr( 'youtube', 'pointify').'">';
									pointify_youtube_icons();
								echo '</a></li>';
							}

							echo '</ul>';
						}
						echo '</div>';
					}
				}
			}
		}else {
			foreach ($user_ids as $user_id) {
				
				$user = get_user_by('ID', $user_id);
				$custom_width = 400; 

				if ($user) {
					$user_avatar = get_avatar_url($user_id, array('size' => $custom_width));
					$user_name = $user->display_name;
					$user_roles = $user->roles;

					echo '<div class="user-slide">';
					echo '<img src="' . esc_url($user_avatar) . '" width="' . esc_attr($custom_width) . '" alt="' . esc_attr($user_name) . '" />';
					echo '<p class="admin-name">' . esc_html($user_name) . '</p>';
					 // Display user roles
					if (!empty($user_roles)) {
						echo '<p class="roles-name">'. esc_html(implode( $user_roles)) . '</p>';
					}
					
					$facebook = get_user_meta($user_id, 'facebook', true);
					$twitter = get_user_meta($user_id, 'twitter', true);
					$instagram = get_user_meta($user_id, 'instagram', true);
					$youtube = get_user_meta($user_id, 'youtube', true);

					if ($facebook || $twitter || $instagram) {
						echo '<ul>';

						if ($facebook) {
							echo '<li><a href="' . esc_url($facebook) . '" title="'.esc_attr( 'facebook', 'pointify').'">';
								pointify_instagram_icons();
							echo '	</a></li>';
						}

						if ($twitter) {
							echo '<li><a href="' . esc_url($twitter) . '" title="'.esc_attr( 'twitter', 'pointify').'">';
								pointify_twitter_icons();
							echo '</a></li>';
						}

						if ($instagram) {
							echo '<li><a href="' . esc_url($instagram) . '" title="'.esc_attr( 'instagram', 'pointify').'">';
								pointify_facebook_icons();
							echo '</a></li>';
						}
						if ($youtube) {
							echo '<li><a href="' . esc_url($youtube) . '" title="'.esc_attr( 'youtube', 'pointify').'">';
								pointify_youtube_icons();
							echo '</a></li>';
						}

						echo '</ul>';
					}
					echo '</div>';
				}
			}
		} 
        echo '</div>';
	}

    public function form($instance) {
		$title = isset($instance['title']) ? $instance['title'] : '';
        $user_ids = !empty($instance['user_ids']) ? esc_attr($instance['user_ids']) : '';
        ?>
		<p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('user_ids'); ?>"><?php _e('User IDs (comma-separated):', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('user_ids'); ?>" name="<?php echo $this->get_field_name('user_ids'); ?>" type="text" value="<?php echo $user_ids; ?>">
        </p>
        <?php
    }

    public function update($new_instance, $old_instance) {
        $instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['user_ids'] = !empty($new_instance['user_ids']) ? sanitize_text_field($new_instance['user_ids']) : '';

        return $instance;
    }
}

// Register the widget
function register_pointify_user_carousel_widget() {
    register_widget('Pointify_User_Carousel_Widget');
}
add_action('widgets_init', 'register_pointify_user_carousel_widget');