<?php

function pointify_custom_theme_widgets_init() {
    // Register Footer Sidebar Widget Areas
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 1', 'pointify' ),
        'id'            => 'footer-widget-1',
        'description'   => esc_html__( 'Add widgets for the first footer column here.', 'pointify' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

	register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 2', 'pointify' ),
        'id'            => 'footer-widget-2',
        'description'   => esc_html__( 'Add widgets for the second footer column here.', 'pointify' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

	register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 3', 'pointify' ),
        'id'            => 'footer-widget-3',
        'description'   => esc_html__( 'Add widgets for the third footer column here.', 'pointify' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

	register_sidebar( array(
        'name'          => esc_html__( 'Footer Column 4', 'pointify' ),
        'id'            => 'footer-widget-4',
        'description'   => esc_html__( 'Add widgets for the fourth footer column here.', 'pointify' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    /**
     * Woocommerce Sidebar
     */

    register_sidebar( array(
        'name'          => esc_html__( 'WooCommerce Sidebar', 'pointify' ),
        'id'            => 'product-page-widget',
        'description'   => esc_html__( 'Add widgets for the product page here.', 'pointify' ),
        'before_widget' => '<div id="%1$s" class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );

    /**
     * Home Page Widgets
     */
    register_sidebar( array(
        'name'          => __( 'Homepage Widget Area', 'pointify' ),
        'id'            => 'widget-area-front-page',
        'description'   => __( 'Choose what should display on the custom static homepage.', 'pointify' ),
        'before_widget' => '<section id="%1$s" class="widget widget--home %2$s">',
        'after_widget'  => '</section>',
    ) );

    /**
     * Pricing Plan Page Widgets
     */
    if ( class_exists( 'Extensify' ) ) {
        register_sidebar( array(
            'name'          => __( 'Pricing Page Widget Area', 'pointify' ),
            'id'            => 'widget-area-pricing-plan-page',
            'description'   => __( 'Choose what should display on the custom static pricing plan.', 'pointify' ),
            'before_widget' => '<section id="%1$s" class="widget widget--home %2$s">',
            'after_widget'  => '</section>',
        ) );

        /**
         * Job Single Listing Siebar Widgets
         */
    
        register_sidebar( array(
            'name'          => __( 'Job Single Listing Sidebar Widget Area', 'pointify' ),
            'id'            => 'widget-area-job-single-listing-sidebar-page',
            'description'   => __( 'Choose what should display on the job single lsiting widget.', 'pointify' ),
            'before_widget' => '<section id="%1$s" class="widget widget--job_single_listing %2$s">',
            'after_widget'  => '</section>',
        ) );

    }

    /**
     * How it work
     */
    $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

    if ( $style_demo === 'job_board' ) {
        register_sidebar( array(
            'name'          => __( 'How it work Page Widget Area', 'pointify' ),
            'id'            => 'widget-area-how-it-work-page',
            'description'   => __( 'Choose what should display on the how it work page.', 'pointify' ),
            'before_widget' => '<section id="%1$s" class="widget widget--how-it-work %2$s">',
            'after_widget'  => '</section>',
        ) );
    }

}
add_action( 'widgets_init', 'pointify_custom_theme_widgets_init' );