<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_Tabbed_Listing extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_tabbed_listing_widget',
            __('Pointify - Page: Tabbed Listing Widget', 'pointify'),
            array('description' => __('A pointify widget for tabbed listing', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $heading = ! empty( $instance['heading'] ) ? $instance['heading'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $number = ! empty( $instance['number'] ) ? $instance['number'] : '';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

		if($style_demo === 'lawyer'){
        ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'heading' ); ?>">Heading:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'heading' ); ?>" name="<?php echo $this->get_field_name( 'heading' ); ?>" type="text" value="<?php echo esc_attr( $heading ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of posts to display in tabbed:', 'pointify' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" min="1">
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['heading'] = ( ! empty( $new_instance['heading'] ) ) ? sanitize_text_field( $new_instance['heading'] ) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? absint( $new_instance['number'] ) : 4;

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';
        $description = !empty($instance['description']) ? $instance['description'] : '';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        if($style_demo === 'lawyer'){ 
            $highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
            $heading = !empty($instance['heading']) ? $instance['heading'] : '';
        }

        echo $args['before_widget'];
        ?>
        <div class="popular-listing-section">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($heading) ) {
                                    ?>
                                    <h4><?php echo $heading; ?></h4>
                                    <?php
                                }
                                if (!empty($title) ) {
                                    ?>
                                    <h3 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h3>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                            ?>
                        </div>
                    </div>
                    
                    <?php
                        $job_listing_categories = get_terms( array(
                            'taxonomy'   => 'job_listing_category',
                            'hide_empty' => false, // Set to false to also retrieve categories with no posts assigned
                        ) );
                    ?>

                    <ul class="tabbed-listings-tabs">
                            <?php foreach ( $job_listing_categories as $term ) : ?>
                            <li><a href="#tab-<?php echo esc_html( $term->term_id ); ?>" title="<?php echo esc_html( $term->name ); ?>"><?php echo esc_html( $term->name ); ?></a></li>
                        <?php endforeach; ?>
                    </ul>
                    
                    <div class="tabbed-listings-tabs-wrapper">

                        <?php foreach ( $job_listing_categories as $term ) : ?>

                        <div id="tab-<?php echo esc_attr( $term->term_id ); ?>" class="listings-tab">

                                <?php
                                $job_listing_tab_args = array(
                                    'post_type'      => 'job_listing',
                                    'posts_per_page' => $instance['number'], // Display all job listings in the category
                                    'tax_query'      => array(
                                        array(
                                            'taxonomy' => 'job_listing_category',
                                            'field'    => 'term_id',
                                            'terms'    => $term->term_id,
                                        ),
                                    ),
                                );

                                $job_listings = new WP_Query( $job_listing_tab_args );
                                    // Display job listings
                                    if ( $job_listings->have_posts() ) {
                                        while ( $job_listings->have_posts() ) {
                                            $job_listings->the_post();

                                            $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
                                            if($style_demo === 'business' ) {
                                            ?>
                                            <div id="job_listing-<?php the_ID(); ?>" class="job-listing">
                                                <div class="content-box">
                                                    <?php
                                                        $job_listing_id = get_the_ID();
                                                        $job_title = get_the_title( $job_listing_id );
                                                        $featured_image = get_post_meta( $job_listing_id, '_featured_image', true );
                                                        $job_location = get_post_meta( $job_listing_id, '_job_location', true );
                                                        $job_salary = get_post_meta( $job_listing_id, '_job_salary', true );
                                                        $job_salary_currency = get_post_meta( $job_listing_id, '_job_salary_currency', true );
                                                    ?>
                                                    <div class="feature-image-section">
                                                        <?php if(!empty($job_salary)) { ?>
                                                            <div class="listing-pricing">
                                                                <h5><?php echo $job_salary_currency .' '. $job_salary; ?></h5>
                                                            </div>
                                                        <?php }
                                                        if($featured_image) { ?>
                                                            <img src="<?php echo $featured_image; ?>" alt="<?php echo $job_title; ?>-img" class="feature-img">
                                                        <?php } else {
                                                            ?>
                                                            <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img' ?>" alt="<?php echo $job_title; ?>-img" class="feature-img">
                                                            <?php
                                                        } 
                                                        if ( has_post_thumbnail() ) {
                                                        ?>
                                                            <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
                                                        <?php } else {
                                                            ?>
                                                            <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                                                            <?php
                                                        } ?>
                                                    </div>

                                                    <div class="job-listing-details">
                                                        <?php if(!empty($job_title)) { ?>
                                                            <div class="job-title">
                                                                <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                                                            </div>
                                                        <?php }   
                                                            if(!empty($job_location)){
                                                        ?>
                                                                <div class="job-location">
                                                                    <span><?php echo $job_location; ?></span>
                                                                </div>
                                                        <?php } ?>
                                                    </div>

                                                    <div class="listing_review_fav">
                                                        <?php if ( is_position_filled() ) { ?>
                                                            <span class="position-filled closed"><?php _e( 'Closed', 'pointify' ); ?></span> 
                                                        <?php } else { ?>
                                                                <span class="position-filled open"><?php _e( 'Open', 'pointify' ); ?></span> 
                                                        <?php }
                                                            if(class_exists('WP_Job_Manager_Reviews')) { ?>
                                                            <div class="listing_review_cls">
                                                                <?php
                                                                    echo wpjmr_reviews_get_stars($job_listing_id);
                                                                    echo wpjmr_get_reviews_average($job_listing_id);
                                                                ?>
                                                            </div>
                                                        <?php
                                                            }
                                                            if (class_exists('Astoundify\Favorites\Favorite')) {
                                                        ?>
                                                            <div class="listing_fav_sec">
                                                                <?php echo astoundify_favorites_link($job_listing_id); ?>	
                                                            </div>
                                                        <?php } ?>
                                                    </div>

                                                </div>   
                                            </div>
                                            <?php } elseif ($style_demo === 'job_board') { 
                                                
                                                ?>
                                                <div id="job_listing-<?php the_ID(); ?>" class="job-listing job_listing job_board_main_list">
                                                    <div class="content-box">
                                                        <div class="job_board_list">
                                                            <?php
                                                                $job_listing_id = get_the_ID();
                                                                $job_title = get_the_title( $job_listing_id );
                                                                $job_salary = get_post_meta( $job_listing_id, '_job_salary', true );
                                                                $job_salary_currency = get_post_meta( $job_listing_id, '_job_salary_currency', true );
                                                                
                                                                $job_types = wp_get_post_terms($job_listing_id, 'job_listing_type');

                                                                $job_post_date = get_post_field('post_date', $job_listing_id);
                                                                $timestamp = strtotime($job_post_date);
                                                                $formatted_date = date_i18n('d M Y', $timestamp);
                                                            ?>
                                                            <div class="feature-image-section">
                                                                <?php 
                                                                    if ( has_post_thumbnail() ) {
                                                                ?>
                                                                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
                                                                <?php } else {
                                                                    ?>
                                                                    <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                                                                    <?php
                                                                } ?>
                                                            </div>

                                                            <div class="job-listing-details">
                                                                <?php 
                                                                    if (!empty($job_types) && !is_wp_error($job_types)) {
                                                                        $job_type = $job_types[0]; ?>
                                                                    <span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
                                                                <?php        
                                                                    }
                                                                ?>
                                                                <?php if(!empty($job_title)) { ?>
                                                                    <div class="job-title">
                                                                        <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                                                                    </div>
                                                                <?php } ?>
                                                                <span class="job-publish-cls"><?php echo $formatted_date; ?></span>
                                                            </div>
                                                        </div>

                                                        <?php 
                                                            $job_salary_unit = get_post_meta( $job_listing_id, '_job_salary_unit', true );
                                                            $job_salary_unit_capitalized = strtolower($job_salary_unit);
                                                        ?>
                                                        <div class="job-bottom-content">
                                                            <?php
                                                                if(!empty($job_salary)) { ?>
                                                                    <div class="listing-pricing">
                                                                        <h4><?php echo $job_salary_unit_capitalized . ' ' . __('Package', 'pointify'); ?></h4>
                                                                        <h5><?php echo $job_salary_currency .' '. $job_salary; ?></h5>
                                                                    </div>
                                                                <?php }
                                                            ?>
                                                            <div class="job-single-btn-cls">
                                                                <a href="<?php echo esc_url( get_permalink() ); ?>"><?php _e('Apply Now', 'pointify'); ?></a>
                                                            </div>
                                                        </div>

                                                    </div>   
                                                </div>
                                            <?php
                                            } elseif ($style_demo === 'lawyer') { ?>
                                                <div id="job_listing-<?php the_ID(); ?>" class="job-listing job_listing job_board_main_list">
                                                    <div class="content-box">
                                                        <div class="job_board_list">
                                                            <?php
                                                                $job_listing_id = get_the_ID();
                                                                $job_title = get_the_title( $job_listing_id );
                                                                $job_location = get_post_meta( $job_listing_id, '_job_location', true );
                                                                $job_types = wp_get_post_terms($job_listing_id, 'job_listing_type');

                                                            ?>
                                                            <div class="feature-image-section">
                                                                <?php 
                                                                    if ( has_post_thumbnail() ) {
                                                                ?>
                                                                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full'); ?>" class="post-thumbnail-img">
                                                                <?php } else {
                                                                    ?>
                                                                    <img src="<?php echo esc_url(get_template_directory_uri()) . '/assets/img/job-feature-placeholder-img.jpg' ?>" alt="<?php echo $job_title; ?>-img" class="post-thumbnail-img">
                                                                    <?php
                                                                } ?>
                                                            </div>

                                                            <div class="job-listing-details">
                                                                <?php if(!empty($job_title)) { ?>
                                                                    <div class="job-title">
                                                                        <h4><a href="<?php echo esc_url( get_permalink() ); ?>" title="<?php echo $job_title; ?>"><?php echo $job_title; ?></a></h4>
                                                                    </div>
                                                                <?php } 
                                                                    if (!empty($job_types) && !is_wp_error($job_types)) {
                                                                        $job_type = $job_types[0]; ?>
                                                                    <span class="job-type-cls"><?php echo esc_html($job_type->name); ?></span>
                                                                <?php        
                                                                    }
                                                                if (class_exists('Astoundify\Favorites\Favorite')) {
                                                                ?>
                                                                    <div class="listing_fav_sec">
                                                                        <?php echo astoundify_favorites_link($job_listing_id); ?>	
                                                                    </div>
                                                                <?php } ?>
                                                            </div>
                                                            <?php
                                                            if(class_exists('WP_Job_Manager_Reviews')) { ?>
                                                                <div class="listing_review_cls">
                                                                    <?php
                                                                        echo wpjmr_reviews_get_stars($job_listing_id);
                                                                        echo wpjmr_get_reviews_average($job_listing_id);
                                                                    ?>
                                                                </div>
                                                            <?php
                                                                }
                                                                if(!empty($job_location)){
                                                                    ?>
                                                                            <div class="job-location">
                                                                                <span><?php echo $job_location; ?></span>
                                                                            </div>
                                                                <?php }  ?>
                                                        </div>

                                                        <div class="job-bottom-content">
                                                        
                                                            <div class="job-single-btn-cls">
                                                                <a href="<?php echo esc_url( get_permalink() ); ?>"><?php _e('Contact Now', 'pointify'); ?></a>
                                                            </div>
                                                        </div>

                                                    </div>   
                                                </div>
                                            <?php }
                                        }
                                        wp_reset_postdata(); // Reset post data
                                    } else {
                                        echo 'No job listings found in this category.';
                                    }
                                ?>

                        </div>

                        <?php endforeach; ?>

                </div>

                </div>
            </div>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

}

// Register and load the widget
function pointify_tabbed_listing_widget() {
    register_widget('Pointify_Widget_Tabbed_Listing');
}
add_action('widgets_init', 'pointify_tabbed_listing_widget');
