<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Popular_Listings_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_popular_listings_widget',
            __('Pointify - Page: Popular Listings Widget', 'pointify'),
            array('description' => __('A pointify widget for popular listings', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $heading_popular = ! empty( $instance['heading_popular'] ) ? $instance['heading_popular'] : '';
        $highlighted_title_popular = ! empty( $instance['highlighted_title_popular'] ) ? $instance['highlighted_title_popular'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

        if($style_demo === 'lawyer'){
            ?>
            <p>
                <label for="<?php echo $this->get_field_id( 'heading_popular' ); ?>">Heading:</label>
                <input class="widefat" id="<?php echo $this->get_field_id( 'heading_popular' ); ?>" name="<?php echo $this->get_field_name( 'heading_popular' ); ?>" type="text" value="<?php echo esc_attr( $heading_popular ); ?>">
            </p>
        <?php } ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title_popular' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title_popular' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title_popular' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title_popular ); ?>">
			</p>
		<?php } ?>

        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['heading_popular'] = ( ! empty( $new_instance['heading_popular'] ) ) ? sanitize_text_field( $new_instance['heading_popular'] ) : '';
        $instance['highlighted_title_popular'] = ( ! empty( $new_instance['highlighted_title_popular'] ) ) ? sanitize_text_field( $new_instance['highlighted_title_popular'] ) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
        if($style_demo === 'lawyer'){
            $heading_popular = !empty($instance['heading_popular']) ? $instance['heading_popular'] : '';
            $highlighted_title_popular = !empty($instance['highlighted_title_popular']) ? $instance['highlighted_title_popular'] : '';
        }

        $description = !empty($instance['description']) ? $instance['description'] : '';

        echo $args['before_widget'];
        ?>
        <div class="popular-listing-section">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if($style_demo === 'lawyer'){
									if(!empty($heading_popular)){ ?>
											<h4><?php echo $heading_popular; ?></h4>
								<?php }
                                    if (!empty($title) ) {
                                        ?>
                                        <h3 class="high_text" data-hight-text="<?php echo $highlighted_title_popular; ?>"><?php echo $title; ?></h3>
                                        <?php
                                    }
                                    if (!empty($description)) {
                                        ?>
                                        <p><?php echo esc_html($description); ?></p>
                                        <?php
                                    }
                                } else {
                                    if (!empty($title) ) {
                                        ?>
                                        <h3><?php echo $title; ?></h3>
                                        <?php
                                    }
                                    if (!empty($description)) {
                                        ?>
                                        <p><?php echo esc_html($description); ?></p>
                                        <?php
                                    }
                                }
                            ?>
                        </div>
                        <div class="popular-listing-caption">
                            <?php
                                $style_demo = get_theme_mod( 'pointify_demo_selection', '' );

                                if($style_demo === 'job_board'){
                            ?>
                            <div class="shape_one">
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/job-board/shape-1.png" />
                            </div>
                            <div class="shape_two">
                                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/job-board/shape-2.png" />
                            </div>
                            <?php } ?>
                            <?php echo do_shortcode('[jobs show_filters="false"]'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

}

// Register and load the widget
function pointify_popular_listings_widget() {
    register_widget('Pointify_Popular_Listings_Widget');
}
add_action('widgets_init', 'pointify_popular_listings_widget');
