<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Latest_Listings_Widget extends WP_Widget {

    public function __construct() {
        parent::__construct(
            'pointify_latest_listings_widget',
            __('Pointify - Page: Latest Listings Widget', 'pointify'),
            array('description' => __('A pointify widget for latest listings', 'pointify'))
        );
    }

    // Widget backend
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $number = ! empty( $instance['number'] ) ? $instance['number'] : 3;
        $background_image = !empty($instance['background_image']) ? $instance['background_image'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>
        <p>
            <label for="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>"><?php esc_html_e( 'Number of listing to display:', 'pointify' ); ?></label>
            <input class="widefat" id="<?php echo esc_attr( $this->get_field_id( 'number' ) ); ?>" name="<?php echo esc_attr( $this->get_field_name( 'number' ) ); ?>" type="number" value="<?php echo esc_attr( $number ); ?>" min="1">
        </p>
        <!-- Widget background image -->
        <p>
            <label for="<?php echo $this->get_field_id('background_image'); ?>"><?php _e('Background Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('background_image'); ?>" name="<?php echo $this->get_field_name('background_image'); ?>" type="text" value="<?php echo esc_attr($background_image); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>
        <?php
    }

    // Updating widget replacing old instances with new
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['number'] = ( ! empty( $new_instance['number'] ) ) ? absint( $new_instance['number'] ) : 3;
        $instance['background_image'] = (!empty($new_instance['background_image'])) ? esc_url($new_instance['background_image']) : '';

        return $instance;
    }

    // Widget frontend
    public function widget($args, $instance) {
        $title = !empty($instance['title']) ? $instance['title'] : 'Popular Listings';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $background_image = esc_url($instance['background_image']);
        $listing_number = $instance['number'];
        echo $args['before_widget'];
        ?>
        <div class="pointify-how-it-works" style="background-image: url(<?php echo esc_url($background_image); ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($title) ) {
                                    ?>
                                    <h3><?php echo $title; ?></h3>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                            ?>
                        </div>
                        <div class="popular-listing-caption latest-listing">
                            <?php echo do_shortcode('[jobs show_filters="false" per_page="'.$listing_number.'"]'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
        // Add your popular listings code here
        echo $args['after_widget'];
    }

}

// Register and load the widget
function pointify_latest_listings_widget() {
    register_widget('Pointify_Latest_Listings_Widget');
}
add_action('widgets_init', 'pointify_latest_listings_widget');
