<?php
// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Pointify_Widget_CTA_Section extends WP_Widget {

    // Widget setup.
    public function __construct() {
        $widget_ops = array(
            'classname'   => 'widget-home-cta-section',
            'description' => esc_html__( 'Display a CTA Section area.', 'pointify' ),
        );
        parent::__construct( 'pointify_widget_cta_section', esc_html__( 'Pointify - Page: CTA Section', 'pointify' ), $widget_ops );
    }

    // Widget form creation
    public function form($instance) {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $highlighted_title = ! empty( $instance['highlighted_title'] ) ? $instance['highlighted_title'] : '';
        $description = !empty($instance['description']) ? $instance['description'] : '';
        $background_image = !empty($instance['background_image']) ? $instance['background_image'] : '';
        $cta_title = !empty($instance['cta_title']) ? $instance['cta_title'] : '';
        $cta_url = !empty($instance['cta_url']) ? $instance['cta_url'] : '';
        // Widget title
        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>"><?php _e('Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>

        <?php
		if($style_demo === 'lawyer'){
			?>
			<p>
				<label for="<?php echo $this->get_field_id( 'highlighted_title' ); ?>">Highlighted Title:</label>
				<input class="widefat" id="<?php echo $this->get_field_id( 'highlighted_title' ); ?>" name="<?php echo $this->get_field_name( 'highlighted_title' ); ?>" type="text" value="<?php echo esc_attr( $highlighted_title ); ?>">
			</p>
		<?php } ?>

        <!-- Widget description -->
        <p>
            <label for="<?php echo $this->get_field_id('description'); ?>"><?php _e('Description:', 'pointify'); ?></label>
            <textarea class="widefat" id="<?php echo $this->get_field_id('description'); ?>" name="<?php echo $this->get_field_name('description'); ?>"><?php echo esc_textarea($description); ?></textarea>
        </p>

         <!-- CTA Title -->
         <p>
            <label for="<?php echo $this->get_field_id('cta_title'); ?>"><?php _e('CTA Title:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('cta_title'); ?>" name="<?php echo $this->get_field_name('cta_title'); ?>" type="text" value="<?php echo esc_attr($cta_title); ?>">
        </p>

        <!-- CTA URl -->
        <p>
            <label for="<?php echo $this->get_field_id('cta_url'); ?>"><?php _e('CTA URL:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('cta_url'); ?>" name="<?php echo $this->get_field_name('cta_url'); ?>" type="text" value="<?php echo esc_attr($cta_url); ?>">
        </p>

        <!-- Widget background image -->
        <p>
            <label for="<?php echo $this->get_field_id('background_image'); ?>"><?php _e('Background Image:', 'pointify'); ?></label>
            <input class="widefat" id="<?php echo $this->get_field_id('background_image'); ?>" name="<?php echo $this->get_field_name('background_image'); ?>" type="text" value="<?php echo esc_attr($background_image); ?>">
            <button class="button button-secondary" onclick="openMediaUploader(this); return false;"><?php _e('Select Image', 'pointify'); ?></button>
            <a class="button pointify-widget-media-clear"><?php esc_html_e( 'Clear', 'pointify' ); ?></a>
        </p>


        <?php
    }

    // Widget update
    public function update($new_instance, $old_instance) {
        $instance = array();
        $instance['title'] = (!empty($new_instance['title'])) ? sanitize_text_field($new_instance['title']) : '';
        $instance['highlighted_title'] = ( ! empty( $new_instance['highlighted_title'] ) ) ? sanitize_text_field( $new_instance['highlighted_title'] ) : '';
        $instance['cta_title'] = (!empty($new_instance['cta_title'])) ? sanitize_text_field($new_instance['cta_title']) : '';
        $instance['cta_url'] = (!empty($new_instance['cta_url'])) ? sanitize_text_field($new_instance['cta_url']) : '';
        $instance['description'] = (!empty($new_instance['description'])) ? sanitize_text_field($new_instance['description']) : '';
        $instance['background_image'] = (!empty($new_instance['background_image'])) ? esc_url($new_instance['background_image']) : '';

        return $instance;
    }

    // Widget display
    public function widget($args, $instance) {
        $title = apply_filters('widget_title', $instance['title']);

        $style_demo = get_theme_mod( 'pointify_demo_selection', '' );
		if($style_demo === 'lawyer'){ 
			$highlighted_title = !empty($instance['highlighted_title']) ? $instance['highlighted_title'] : '';
		}

        $cta_title = apply_filters('widget_cta_title', $instance['cta_title']);
        $cta_url = apply_filters('widget_cta_url', $instance['cta_url']);
        $description = esc_html($instance['description']);
        $background_image = esc_url($instance['background_image']);

        // Output before widget
        echo $args['before_widget'];

        ?>
        <div class="pointify-cta-sections" style="background-image: url(<?php echo esc_url($background_image); ?>);">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="widget-title-desc-caption">
                            <?php
                                if (!empty($title) ) {
                                    ?>
                                    <h2 class="high_text" data-hight-text="<?php echo $highlighted_title; ?>"><?php echo $title; ?></h2>
                                    <?php
                                }
                                if (!empty($description)) {
                                    ?>
                                    <p><?php echo esc_html($description); ?></p>
                                    <?php
                                }
                                if (!empty($cta_title)) {
                                    ?>
                                    <a href="<?php echo $cta_url; ?>" class="btn-primary" title="<?php echo $cta_title; ?>"><?php echo $cta_title; ?> <i class="fa fa-plus" aria-hidden="true"></i></a>
                                    <?php
                                }
                            ?>
                        </div>                        
                    </div>
                </div>
            </div>
        </div>
        <?php
        echo $args['after_widget'];
    }

}

// Register the widget.
function register_pointify_widget_cta_section() {
    register_widget( 'Pointify_Widget_CTA_Section' );
}
add_action( 'widgets_init', 'register_pointify_widget_cta_section' );

