<?php
// Register the widget
function job_single_location_widgets_init() {
    register_widget( 'Job_Single_location_Widget' );
}
add_action( 'widgets_init', 'job_single_location_widgets_init' );

// Create the widget class
class Job_Single_location_Widget extends WP_Widget {

    // Constructor
    function __construct() {
        parent::__construct(
            'job_single_location_widgets_init',
            __( 'Pointify - Job Single Location Widget', 'pointify' ),
            array( 'description' => __( 'A widget to display location, email, and site URL', 'pointify' ), )
        );
    }

    // Widget form
    public function form( $instance ) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        $location_checked = isset( $instance['location'] ) ? $instance['location'] : '';
        $email_checked = isset( $instance['email'] ) ? $instance['email'] : '';
        $siteurl_checked = isset( $instance['siteurl'] ) ? $instance['siteurl'] : '';
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">Title:</label>
            <input class="widefat" id="<?php echo $this->get_field_id('title'); ?>" name="<?php echo $this->get_field_name('title'); ?>" type="text" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $location_checked, 'on' ); ?> id="<?php echo $this->get_field_id( 'location' ); ?>" name="<?php echo $this->get_field_name( 'location' ); ?>" />
            <label for="<?php echo $this->get_field_id( 'location' ); ?>"><?php _e( 'Display Location', 'pointify' ); ?></label>
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $email_checked, 'on' ); ?> id="<?php echo $this->get_field_id( 'email' ); ?>" name="<?php echo $this->get_field_name( 'email' ); ?>" />
            <label for="<?php echo $this->get_field_id( 'email' ); ?>"><?php _e( 'Display Email', 'pointify' ); ?></label>
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $siteurl_checked, 'on' ); ?> id="<?php echo $this->get_field_id( 'siteurl' ); ?>" name="<?php echo $this->get_field_name( 'siteurl' ); ?>" />
            <label for="<?php echo $this->get_field_id( 'siteurl' ); ?>"><?php _e( 'Display Site URL', 'pointify' ); ?></label>
        </p>
        <?php
    }

    // Update widget settings
    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['title'] = sanitize_text_field($new_instance['title']);
        $instance['location'] = isset( $new_instance['location'] ) ? 'on' : 'off';
        $instance['email'] = isset( $new_instance['email'] ) ? 'on' : 'off';
        $instance['siteurl'] = isset( $new_instance['siteurl'] ) ? 'on' : 'off';
        return $instance;
    }

    // Display the widget
    public function widget( $args, $instance ) {
        $title = isset($instance['title']) ? $instance['title'] : '';
        $location_checked = isset( $instance['location'] ) ? $instance['location'] : '';
        $email_checked = isset( $instance['email'] ) ? $instance['email'] : '';
        $siteurl_checked = isset( $instance['siteurl'] ) ? $instance['siteurl'] : '';
        
        echo $args['before_widget'];
        $job_id = get_the_ID();
        $job_location = get_post_meta( $job_id, '_job_location', true );
        $company_name = get_post_meta( $job_id, '_company_name', true );
        $company_website = get_post_meta( $job_id, '_company_website', true );
        $application = get_post_meta( $job_id, '_application', true );
        ?>
        <div class="listing-location-info">
            <?php
                if(!empty($title)){ ?>
                    <div class="location_title">
                        <h2 class="widget-title"><?php echo $title; ?></h2>
                    </div><?php
                }
            ?>
            <?php
                if ( $location_checked == 'on' ) {
            ?>
                <div class="info-caption">
                    <p><i class="fa fa-map-marker" aria-hidden="true"></i><?php echo $job_location; ?></p>
                </div>
            <?php
                }
                if ( $email_checked == 'on' ) {
            ?>
                <div class="info-caption">
                    <p><i class="fa fa-envelope-o" aria-hidden="true"></i><?php
                            //$admin_email = get_option( 'admin_email' );
                            echo $application;
                    ?></p>
                </div>
            <?php
                }
                if ( $siteurl_checked == 'on' ) {
            ?>
                <div class="info-caption site-url">
                    <p><i class="fa fa-globe" aria-hidden="true"></i>
                        <a href="<?php echo esc_url($company_website); ?>" title="<?php echo $company_website; ?>"><?php echo $company_website; ?></a>
                    </p>
                </div>
            <?php
                }
            ?>
        </div>
        <?php        
        echo $args['after_widget'];
    }
}
