jQuery( document ).ready( function($) {
	
    if ( typeof gjmAddressAutocompleteOptions !== 'undefined' ) {
        
        //do it for each autocomplete field in the form
        $.each( gjmAddressAutocompleteOptions.fields, function( index, field ) {

        	// make sure field exist on page
        	if ( ! $( '#' + field ).length ) {
        		return;
        	}

            var inputField = document.getElementById( field );

            // autocomplete options
            var options = {
                types : [gjmAddressAutocompleteOptions.results_type]
            };

            if ( gjmAddressAutocompleteOptions.restrict_country != '' ) {
                options.componentRestrictions = { 
                    country : gjmAddressAutocompleteOptions.restrict_country
                };
            } 
            
            var autocomplete = new google.maps.places.Autocomplete( inputField, options );
            
            google.maps.event.addListener( autocomplete, 'place_changed', function(e) {

                var place = autocomplete.getPlace();

                if ( ! place.geometry ) {
                    return;
                }
            });
        });
    }   
});
