<?php
/**
 * Admin functions.
 *
 * @package wpjm-jobs-geolocation.
 */

if ( ! defined( 'ABSPATH' ) ) {
	die(); // Exit if accessed directly.
}

/**
 * GJM_Admin class
 */
class GJM_Admin {

	/**
	 * __construct function.
	 *
	 * @access public
	 * @return void
	 */
	 
	public $settings; 
	public function __construct() {

		$this->settings = get_option( 'gjm_options' );

		// include admin files.
		include get_template_directory() . '/inc/includes/admin/class-gjm-admin-settings.php';
		include get_template_directory() . '/inc/includes/admin/gjm-db.php';

		// Enable custom fields in admin when ACF plugin is activated.
		add_filter( 'acf/settings/remove_wp_meta_box', '__return_false' );

		add_action( 'admin_print_scripts-post-new.php', array( $this, 'address_field_features' ), 11 );
		add_action( 'admin_print_scripts-post.php', array( $this, 'address_field_features' ), 11 );
		add_action( 'job_manager_save_job_listing', array( $this, 'update_job_location' ), 99, 2 );
		add_action( 'pmxi_after_xml_import', array( $this, 'pmxi_after_all_import_done' ), 20 );
		add_action( 'goft_wpjm_after_insert_job', array( $this, 'pmxi_location_update' ), 30 );
	}

	/**
	 * Google Places address autocomplete in "Edit Job" page admin.
	 *
	 * @return void [description]
	 */
	public function address_field_features() {

		global $post_type;

		if ( 'job_listing' !== $post_type ) {
			return;
		}		

		GJM_Init::enqueue_google_maps_api();
	}

	/**
	 * Generate geocoding status message below the address field of the Edit Job page.
	 *
	 * @return [type] [description]
	 */
	public function geocoding_status_message() {

		if ( empty( $_GET['post'] ) ) { // WPCS: CSRF ok.
			return;
		}

		return gjm_address_geocoding_status_message( absint( $_GET['post'] ), '_job_location' ); // WPCS: CSRF ok.
	}

	/**
	 * Update Job location when saving job in admin
	 *
	 * @param  integer $post_id post ID.
	 *
	 * @param  object  $post    the post obejct.
	 *
	 * @return void
	 */
	public function update_job_location( $post_id, $post ) {

		$geolocated = get_post_meta( $post_id, 'geolocated', true );

		if ( empty( $_POST['_job_location'] ) || empty( $geolocated ) ) { // WPCS: CSRF ok.

			gjm_delete_location( $post_id );

			return;

		} else {

			self::add_location_to_db( $post_id );
			return;
		}
	}

	/**
	 * Add location data to GEo my WP table in database
	 *
	 * @param integer $post_id post ID.
	 */
	public function add_location_to_db( $post_id ) {

		$values = array();

		$values['title']     = ! empty( $_POST['post_title'] ) ? sanitize_text_field( wp_unslash( $_POST['post_title'] ) ) : ''; // WPCS: CSRF ok.
		$values['post_type'] = 'job_listing';
		$values['address']   = ! empty( $_POST['_job_location'] ) ? sanitize_text_field( wp_unslash( $_POST['_job_location'] ) ) : ''; // WPCS: CSRF ok.
		$values['email']     = ! empty( $_POST['_application'] ) ? sanitize_text_field( wp_unslash( $_POST['_application'] ) ) : ''; // WPCS: CSRF ok.

		gjm_update_location( $post_id, $values );
	}

	/**
	 * Run locations importer when WP all import is done importing.
	 */
	public function pmxi_after_all_import_done() {
		self::import_locations();
	}

	/**
	 * Locations importer.
	 *
	 * @param string $post_type job_listing || resume.
	 */
	public static function import_locations( $post_type = 'job_listing' ) {

		if ( function_exists( 'gjm_import_locations' ) ) {
			return gjm_import_locations( $post_type );
		}
	}
}
new GJM_Admin();
