<?php

// Demos

function pointify_import_files() {
    return [
      [
        'import_file_name'             => 'Business',
        'categories'                   => [ 'Listings' ],
        'import_file_url'            => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/pointify/content.xml',
        'import_widget_file_url'     => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/pointify/widgets.wie',
        'import_customizer_file_url' => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/pointify/customizer.dat',
        'import_preview_image_url'     => get_template_directory_uri() . '/inc/demos/assets/images/pointify.jpg',
        'preview_url'                  => 'https://pointify-demos.astoundify.com/pro/',
      ],
      [
        'import_file_name'             => 'Job Board',
        'categories'                   => [ 'Listings' ],
        'import_file_url'            => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/job-board/content.xml',
        'import_widget_file_url'     => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/job-board/widgets.wie',
        'import_customizer_file_url' => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/job-board/customizer.dat',
        'import_preview_image_url'     => get_template_directory_uri() . '/inc/demos/assets/images/job-board.jpg',
        'preview_url'                  => 'https://pointify-demos.astoundify.com/job-board-pro/',
      ],
      [
        'import_file_name'             => 'Lawyer',
        'categories'                   => [ 'Listings' ],
        'import_file_url'            => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/lawyer/content.xml',
        'import_widget_file_url'     => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/lawyer/widgets.wie',
        'import_customizer_file_url' => 'https://pointify-demos.astoundify.com/wp-content/uploads/demo/lawyer/customizer.dat',
        'import_preview_image_url'     => get_template_directory_uri() . '/inc/demos/assets/images/lawyer.jpg',
        'preview_url'                  => 'https://pointify-demos.astoundify.com/lawyer-pro/',
      ]
    ];
}
add_filter( 'ocdi/import_files', 'pointify_import_files' );


// After Demo Set Main Menu

function pointify_ocdi_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', [
            'menu-1' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
        ]
    );

    // Get the front page.
    $front_page = get_posts(
        [
        'post_type'              => 'page',
        'title'                  => 'Home',
        'post_status'            => 'all',
        'numberposts'            => 1,
        'update_post_term_cache' => false,
        'update_post_meta_cache' => false,
        ]
    );

    if ( ! empty( $front_page ) ) {
        update_option( 'page_on_front', $front_page[0]->ID );
    }

    // Get the blog page.
    $blog_page = get_posts(
        [
        'post_type'              => 'page',
        'title'                  => 'Blog',
        'post_status'            => 'all',
        'numberposts'            => 1,
        'update_post_term_cache' => false,
        'update_post_meta_cache' => false,
        ]
    );

    if ( ! empty( $blog_page ) ) {
        update_option( 'page_for_posts', $blog_page[0]->ID );
    }

    if ( ! empty( $blog_page ) || ! empty( $front_page ) ) {
        update_option( 'show_on_front', 'page' );
    }
}
add_action( 'ocdi/after_import', 'pointify_ocdi_after_import_setup' );  

