<?php
// Add Header Customize setting
function pointify_header_settings($wp_customize) {

    // Section for Footer Settings
    $wp_customize->add_section( 'header_section', array(
        'title'    => __( 'Header Settings', 'pointify' ),
        'priority' => 140,
    ) );

    $wp_customize->add_setting('hide_search', array(
        'default' => false,
        'sanitize_callback' => 'sanitize_text_field',
    ));
	
    if (class_exists('Astoundify\Favorites\Favorite')) {

        $wp_customize->add_setting('hide_favorites', array(
            'default' => false,
            'sanitize_callback' => 'sanitize_text_field',
        ));
        
    }
	
	$wp_customize->add_control('hide_search', array(
        'type' => 'checkbox',
        'label' => __('Hide Search ', 'pointify'),
        'section' => 'header_section',
    ));

    $wp_customize->add_control('hide_favorites', array(
        'type' => 'checkbox',
        'label' => __('Hide Favorites', 'pointify'),
        'section' => 'header_section',
    ));
		
	// Setting for Sticky Header
    $wp_customize->add_setting( 'enable_sticky_header', array(
        'default'           => false,
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'enable_sticky_header', array(
        'label'    => __( 'Enable Sticky Header', 'pointify' ),
        'section'  => 'header_section',
        'type'     => 'checkbox',
        'priority' => 30,
    ) );
	
	$wp_customize->add_setting( 'header_transparent', array(
        'default'           => false,
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'header_transparent', array(
        'label'    => __( 'Header Transparent', 'pointify' ),
        'section'  => 'header_section',
        'type'     => 'checkbox',
        'priority' => 30,
    ) );
	
    if (class_exists('WP_Job_Manager')) {

        $wp_customize->add_setting( 'header_add_listing_text', array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        ) );

        $wp_customize->add_control( 'header_add_listing_text', array(
            'label'    => __( 'Header Add Listing Text', 'pointify' ),
            'section'  => 'header_section',
            'type'     => 'text',
            'priority' => 40,
        ) );

        $wp_customize->add_setting( 'header_add_listing_url', array(
            'default'           => '',
            'sanitize_callback' => 'esc_url_raw',
        ) );

        $wp_customize->add_control( 'header_add_listing_url', array(
            'label'    => __( 'Header Add Listing Url', 'pointify' ),
            'section'  => 'header_section',
            'type'     => 'url',
            'priority' => 50,
        ) );

    }
}
add_action('customize_register', 'pointify_header_settings');

// Add Footer Copyright Text setting to the Customizer
function pointify_footer_copyright_settings_func( $wp_customize ) {
    // Section for Footer Settings
    $wp_customize->add_section( 'footer_section', array(
        'title'    => __( 'Footer Settings', 'pointify' ),
        'priority' => 150,
    ) );

    // Setting for Hide/Show Footer
    $wp_customize->add_setting( 'hide_upper_footer', array(
        'default'           => false,
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'hide_upper_footer', array(
        'label'    => __( 'Hide Upper Footer', 'pointify' ),
        'section'  => 'footer_section',
        'type'     => 'checkbox',
        'priority' => 10,
    ) );

    // Setting for Copyright Text
    $wp_customize->add_setting( 'footer_copyright_text', array(
        'default'           => '',
        'sanitize_callback' => 'sanitize_text_field',
    ) );

    $wp_customize->add_control( 'footer_copyright_text', array(
        'label'    => __( 'Copyright Text', 'pointify' ),
        'section'  => 'footer_section',
        'type'     => 'text',
        'priority' => 10,
    ) );
}
add_action( 'customize_register', 'pointify_footer_copyright_settings_func' );

/**
 * Archive page header bg image
 */

function pointify_custom_theme_customize_register($wp_customize) {
    // Add a section for post archive settings
    $wp_customize->add_section('archive_settings', array(
        'title'    => __('Archive and 404 Error Settings', 'pointify'),
        'priority' => 145,
    ));

    // Add a setting for the post archive background image
    $wp_customize->add_setting('archive_page_header_background_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // Add a setting for the Error 404 background image
    $wp_customize->add_setting('error_page_header_background_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // Add a control for the post archive background image
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'archive_page_header_background_image', array(
        'label'    => __('Archive Page Header Background Image', 'pointify'),
        'section'  => 'archive_settings',
        'settings' => 'archive_page_header_background_image',
    )));

    // Add a control for the post archive background image
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'error_page_header_background_image', array(
        'label'    => __('Error 404 Page Header Background Image', 'pointify'),
        'section'  => 'archive_settings',
        'settings' => 'error_page_header_background_image',
    )));
}
add_action('customize_register', 'pointify_custom_theme_customize_register');

/**
 * Product page header bg image
 */

 function pointify_product_page_header_customize_register($wp_customize) {
    // Add a section for Product Page settings
    $wp_customize->add_section('product_settings', array(
        'title'    => __('Product Page Settings', 'pointify'),
        'priority' => 145,
    ));

    // Add a setting for the Product Page  background image
    $wp_customize->add_setting('product_page_header_background_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    // Add a control for the Product Page  background image
    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'product_page_header_background_image', array(
        'label'    => __('Product Page Header Background Image', 'pointify'),
        'section'  => 'product_settings',
        'settings' => 'product_page_header_background_image',
    )));
}
add_action('customize_register', 'pointify_product_page_header_customize_register');


/**
 * Sign up login popup image
 */

 function pointify_signup_login_image_customize_register($wp_customize) {
  
    $wp_customize->add_section('signup_login_popup_settings', array(
        'title'    => __('Login and Signup Popup Image', 'pointify'),
        'priority' => 145,
    ));

    /**
     * Login 
     */
    $wp_customize->add_setting('login_popup_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    /**
     * Singup
     */
    $wp_customize->add_setting('signup_popup_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'login_popup_image', array(
        'label'    => __('Login Popup Image', 'pointify'),
        'section'  => 'signup_login_popup_settings',
        'settings' => 'login_popup_image',
    )));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'signup_popup_image', array(
        'label'    => __('Sign Up Popup Image', 'pointify'),
        'section'  => 'signup_login_popup_settings',
        'settings' => 'signup_popup_image',
    )));

}
add_action('customize_register', 'pointify_signup_login_image_customize_register');

/**
 * Pointify Demo Settings
 */

function pointify_demos_customize_register( $wp_customize ) {
    // Add section
    $wp_customize->add_section( 'pointify_demo_section', array(
        'title'       => __( 'Demo Settings', 'pointify' ),
        'priority'    => 30,
    ) );

    // Add setting for demo selection
    $wp_customize->add_setting( 'pointify_demo_selection', array(
        'default'   => 'business',
        'transport' => 'refresh',
        'sanitize_callback' => 'pointify_sanitize_demo_selection',
    ) );

    // Add control for demo selection
    $wp_customize->add_control( 'pointify_demo_selection_control', array(
        'label'    => __( 'Select Demo', 'pointify' ),
        'section'  => 'pointify_demo_section', // Updated to new section
        'settings' => 'pointify_demo_selection',
        'type'     => 'radio',
        'choices'  => array(
            'business' => __( 'Business', 'pointify' ),
            'job_board' => __( 'Job Board', 'pointify' ),
            'lawyer' => __( 'Lawyer', 'pointify' ),
        ),
    ) );
}
add_action( 'customize_register', 'pointify_demos_customize_register' );

// Sanitization callback function
function pointify_sanitize_demo_selection( $input ) {
    $valid = array( 'business', 'job_board', 'lawyer' );

    if ( in_array( $input, $valid, true ) ) {
        return $input;
    }

    return 'business'; // Default value
}