<?php
/**
 * The template for displaying archive pages
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Pointify_-_Listing_Directory_WordPress_Theme
 */

 get_header();
 ?>
 
	 <main id="primary" class="site-main">
		 <div class="page_header_section" style="background-image: url(<?php echo esc_url(get_theme_mod('archive_page_header_background_image', 'full')); ?>);">
			 <?php pointify_page_header(); ?>
			 <div class="page_breadcrumb_sec">
				 <?php echo pointify_page_breadcrumb(); ?>
			 </div>
		 </div>
		 <div class="post-pg-main-sec">
			 <div class="container">
				 <div class="row">
					 <div class="col-md-9">
						 <div class="post-main-box">
							 <?php
							 if ( have_posts() ) :
 
								 if ( is_home() && ! is_front_page() ) :
									 ?>
									 <header>
										 <h1 class="page-title screen-reader-text"><?php single_post_title(); ?></h1>
									 </header>
									 <?php
								 endif;
 
								 /* Start the Loop */
								 while ( have_posts() ) :
									 the_post();
 
									 /*
									 * Include the Post-Type-specific template for the content.
									 * If you want to override this in a child theme, then include a file
									 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
									 */
									 get_template_part( 'template-parts/content', get_post_type() );
 
								 endwhile;
 
								 ?>
								 <div class="post-pagination-sec">
									 <?php
									 echo pointify_post_pagination();
									 ?>
								 </div>
								 <?php
							 else :
 
								 get_template_part( 'template-parts/content', 'none' );
 
							 endif;
							 
							 ?>
						 </div>
						 
					 </div>
					 
					 <div class="col-md-3">
						 <div class="sidebar-content">
							 <?php get_sidebar(); ?>
						 </div>
					 </div>
				 </div>
			 </div>
		 </div>
	 </main><!-- #main -->
 
 <?php
 get_footer();
