<?php
/**
 * Template part for displaying single posts.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package mizan_real_estate
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class("zoomInRight wow"); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title">', '</h1>' ); ?>
	</header>
	<div class="single-post-footer">
		<?php
		  do_action( 'mizan_real_estate_single_image' );
		?>
	</div>
	<footer class="entry-footer">
		<?php mizan_real_estate_entry_footer(); ?>
	</footer>
	<div class="entry-content-wrapper">
		<div class="entry-content">
			<?php the_content(); ?>
			<?php
				wp_link_pages( array(
					'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'mizan-real-estate' ),
					'after'  => '</div>',
				) );
			?>
		</div>
	</div>
</article>
