<?php
/**
 * Default theme options.
 *
 * @package mizan_real_estate
 */

if ( ! function_exists( 'mizan_real_estate_get_default_theme_options' ) ) :

	/**
	 * Get default theme options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Default theme options.
	 */
	function mizan_real_estate_get_default_theme_options() {

		$defaults = array();

		//General Option
        $defaults['mizan_real_estate_show_scroll_to_top']          = true;
        $defaults['mizan_real_estate_show_preloader_setting']      = false;
        $defaults['mizan_real_estate_show_data_sticky_setting']    = false;
		$defaults['mizan_real_estate_enable_cursor_dot_outline'] = false;

		// Typography
		$defaults['mizan_real_estate_body_font_family']         = '';
		$defaults['mizan_real_estate_h1_font_family']          	= '';
		$defaults['mizan_real_estate_h1_font_size']         	= '';
		$defaults['mizan_real_estate_h2_font_family']          	= '';
		$defaults['mizan_real_estate_h2_font_size']         	= '';
		$defaults['mizan_real_estate_h3_font_family']          	= '';
		$defaults['mizan_real_estate_h3_font_size']         	= '';
		$defaults['mizan_real_estate_h4_font_family']          	= '';
		$defaults['mizan_real_estate_h4_font_size']         	= '';
		$defaults['mizan_real_estate_h5_font_family']          	= '';
		$defaults['mizan_real_estate_h5_font_size']         	= '';
		$defaults['mizan_real_estate_h6_font_family']          	= '';
		$defaults['mizan_real_estate_h6_font_size']         	= '';

		// Site title And tagline Option

		$defaults['mizan_real_estate_site_title_font_size']         = '';
		$defaults['mizan_real_estate_site_tagline_font_size']         = '';
		$defaults['mizan_real_estate_site_title_color'] = '#FFF';

		// Global Color
		$defaults['mizan_real_estate_first_color']          = '#FB7B18';

        //Post Option
        $defaults['mizan_real_estate_show_post_date_setting']         		 = true;
        $defaults['mizan_real_estate_show_post_heading_setting']      		 = true;
        $defaults['mizan_real_estate_show_post_content_setting']       		 = true;
        $defaults['mizan_real_estate_show_post_admin_setting']         		 = true;
        $defaults['mizan_real_estate_show_post_categories_setting']    		 = true;
        $defaults['mizan_real_estate_show_post_comments_setting']    	 	 = true;
        $defaults['mizan_real_estate_show_post_featured_image_setting']   	 = true;
        $defaults['mizan_real_estate_show_post_tags_setting']    			 = true;
		$defaults['mizan_real_estate_enable_post_navigation'] 				= true;
		
		// Related Post
		$defaults['mizan_real_estate_enable_related_post'] 					= true;
		$defaults['mizan_real_estate_enable_related_post_image'] 					= true;

		// Header.
		$defaults['mizan_real_estate_show_title']            = true;
		$defaults['mizan_real_estate_show_tagline']          = false;

		// Layout.
		$defaults['mizan_real_estate_global_layout']           = 'right-sidebar';
		$defaults['mizan_real_estate_archive_layout']          = 'excerpt';
		$defaults['mizan_real_estate_archive_image']           = 'large';
		$defaults['mizan_real_estate_archive_image_alignment'] = 'center';
		$defaults['mizan_real_estate_single_image']            = 'large';

		// Home Page.
		$defaults['mizan_real_estate_home_content_status'] = true;

		// Wow Animation
        $defaults['mizan_real_estate_animation'] = true;

		// Sticky copyright
        $defaults['mizan_real_estate_sticky_copyright_enable'] = false;
		
		// 404 page
		$defaults['mizan_real_estate_404_page_title']  = esc_html__( 'Oops! That page can&rsquo;t be found.', 'mizan-real-estate' );
		$defaults['mizan_real_estate_404_page_text']  = esc_html__( 'It looks like nothing was found at this location. Maybe try one of the links below or a search?', 'mizan-real-estate' );

		// No Result
		$defaults['mizan_real_estate_no_result_title']  = esc_html__( 'Nothing Found', 'mizan-real-estate' );
		$defaults['mizan_real_estate_no_result_text']  = esc_html__( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'mizan-real-estate' );

		// Footer.
		$defaults['mizan_real_estate_copyright_text']        = esc_html__( 'Copyright &copy; All rights reserved.', 'mizan-real-estate' );
		$defaults['mizan_real_estate_copyright_text_font_size'] = '18';
		$defaults['mizan_real_estate_copyright_text_align'] = 'center';
		$defaults['mizan_real_estate_copyright_background_color'] = '#FB7B18';
		$defaults['mizan_real_estate_copyright_text_color'] = '#fff';

		// Pass through filter.
		$defaults = apply_filters( 'mizan_real_estate_filter_default_theme_options', $defaults );
		return $defaults;
	}

endif;
