<?php
$localdirectory_options = localdirectory_theme_options();

$blog_sec_title = $localdirectory_options['blog_sec_title'];
$blog_sec_sub_title = $localdirectory_options['blog_sec_sub_title'];
$posts_count = $localdirectory_options['blog_post_no'];

?>
<div class="blog-section section-spacing">
	<div class="container">
		<div class="row">
			<div class="col-md-12">
				<div class="section-headings">
                  		<?php
                        if ($blog_sec_title)
                            echo '<h2>' . esc_html($blog_sec_title) . '</h2>';

                        if ($blog_sec_sub_title)
                            echo '<span>' . esc_html($blog_sec_sub_title) . '</span>';
                        ?>
				</div>
				<div class="col-md-12">
					<?php 

        $loop = ($posts_count<=0)?30:$posts_count;
            $args = array(
                'post_type' => 'post',
                'posts_per_page' => esc_attr($loop),
                'post_status' => 'publish',
                'order' => 'desc',
                'orderby' => 'menu_order date',
            );

        $query = new \WP_Query($args);

         if ($query->have_posts()):
            ?>
            <div class="custom-blog-widget">
                        <?php
                        while ($query->have_posts()) : $query->the_post();
                            global $post;
                            $post_format = get_post_format($post->ID);
                            $post_thumbnail_id = get_post_thumbnail_id(get_the_ID());
                            $image = wp_get_attachment_image_src($post_thumbnail_id, 'localdirectory-blog-thumbnail-img');
                            $content = get_the_content();
  

                            if (!empty($image)) {
                                $image_style = "style='background-image:url(" . esc_url($image[0]) . ")'";
                            } else {
                                $image_style = '';
                            }

                            if($loop>=1) :
                                ?>
                                <article class="blog-post">
                                    <div class="blog-img">
                                    <img src="<?php echo esc_url($image[0]); ?>" alt="" />

                                      </div>
                                    <div class="post-content">
                                    <h3 class="entry-title"><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>

                                                                                <?php
                                            $comment_count = get_comments_number();
                                            $archive_year  = get_the_time('Y');
                                            $archive_month = get_the_time('m');
                                            echo '<div class="entry-meta"><div class="author">
<a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'" title="'.esc_attr(get_the_author()).'">';
                                            ?>
<svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
  <path fill-rule="evenodd" d="M12 20a7.966 7.966 0 0 1-5.002-1.756l.002.001v-.683c0-1.794 1.492-3.25 3.333-3.25h3.334c1.84 0 3.333 1.456 3.333 3.25v.683A7.966 7.966 0 0 1 12 20ZM2 12C2 6.477 6.477 2 12 2s10 4.477 10 10c0 5.5-4.44 9.963-9.932 10h-.138C6.438 21.962 2 17.5 2 12Zm10-5c-1.84 0-3.333 1.455-3.333 3.25S10.159 13.5 12 13.5c1.84 0 3.333-1.455 3.333-3.25S13.841 7 12 7Z" clip-rule="evenodd"/>
</svg>
                                            <?php echo '<span>'.get_the_author().'</span></a></div>';
                
                                            echo '<div class="date"><a href="'.esc_url(get_month_link($archive_year,$archive_month)).'"><svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
  <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m11.5 11.5 2.071 1.994M4 10h5m11 0h-1.5M12 7V4M7 7V4m10 3V4m-7 13H8v-2l5.227-5.292a1.46 1.46 0 0 1 2.065 2.065L10 17Zm-5 3h14a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1Z"/>
</svg>
<span>'.esc_html(get_the_date()).'</span></a></div></div>';
                                            ?>

                                            <?php
                                         
                
                                            
                                            ?>
                                            <p class="post-excerpt"><?php echo wp_kses_post(localdirectory_get_excerpt(get_the_ID(), 125)); ?></p>
                                        </div>
                                    </article>
                                <?php $loop--; endif; endwhile;
                        wp_reset_postdata(); ?>
                    </div>

                <?php endif; ?>
			</div>
        </div>
		</div>
	</div>
</div>
