<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Localdirectory
 */

?>

<?php if (is_archive() || is_home()){ ?>
  <article class="blog-post" id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                        <?php
                      
                            global $post;
                            $loop=1;
                            $post_format = get_post_format($post->ID);
                            $post_thumbnail_id = get_post_thumbnail_id(get_the_ID());
                            $image = wp_get_attachment_image_src($post_thumbnail_id, 'localdirectory-blog-thumbnail-img');
                            $content = get_the_content();
  

                            if (!empty($image)) {
                                $image_style = "style='background-image:url(" . esc_url($image[0]) . ")'";
                            } else {
                                $image_style = '';
                            }

                            if($loop>=1) :
                                ?>
                              
                                    <div class="blog-img">
                                    <img src="<?php echo esc_url($image[0]); ?>" alt="" />

                                      </div>
                                    <div class="post-content">
                                    <h3 class="entry-title"><a href="<?php echo esc_url(get_the_permalink()); ?>"><?php the_title(); ?></a></h3>

                                                                                <?php
                                            $comment_count = get_comments_number();
                                            $archive_year  = get_the_time('Y');
                                            $archive_month = get_the_time('m');
                                            echo '<div class="entry-meta"><div class="author">
<a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'" title="'.esc_attr(get_the_author()).'">';
                                            ?>
<svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" viewBox="0 0 24 24">
  <path fill-rule="evenodd" d="M12 20a7.966 7.966 0 0 1-5.002-1.756l.002.001v-.683c0-1.794 1.492-3.25 3.333-3.25h3.334c1.84 0 3.333 1.456 3.333 3.25v.683A7.966 7.966 0 0 1 12 20ZM2 12C2 6.477 6.477 2 12 2s10 4.477 10 10c0 5.5-4.44 9.963-9.932 10h-.138C6.438 21.962 2 17.5 2 12Zm10-5c-1.84 0-3.333 1.455-3.333 3.25S10.159 13.5 12 13.5c1.84 0 3.333-1.455 3.333-3.25S13.841 7 12 7Z" clip-rule="evenodd"/>
</svg>
                                            <?php echo '<span>'.get_the_author().'</span></a></div>';
                
                                            echo '<div class="date"><a href="'.esc_url(get_month_link($archive_year,$archive_month)).'"><svg class="w-6 h-6 text-gray-800 dark:text-white" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="none" viewBox="0 0 24 24">
  <path stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="m11.5 11.5 2.071 1.994M4 10h5m11 0h-1.5M12 7V4M7 7V4m10 3V4m-7 13H8v-2l5.227-5.292a1.46 1.46 0 0 1 2.065 2.065L10 17Zm-5 3h14a1 1 0 0 0 1-1V7a1 1 0 0 0-1-1H5a1 1 0 0 0-1 1v12a1 1 0 0 0 1 1Z"/>
</svg>
<span>'.esc_html(get_the_date()).'</span></a></div></div>';
                                            ?>

                                            <?php
                                         
                
                                            
                                            ?>
                                            <p class="post-excerpt"><?php echo wp_kses_post(localdirectory_get_excerpt(get_the_ID(), 125)); ?></p>
                                        </div>
                                 
                                <?php $loop--; endif;
                        wp_reset_postdata(); ?>
                    </article>
               <!-- #post-<?php the_ID(); ?> -->


<?php } else{ ?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<?php if (is_archive() || is_home()){ ?>
	    <?php global $post;
	    $post_format = get_post_format($post->ID);
	    $blog_post_author = get_avatar(get_the_author_meta('ID'), 32);
	    $post_thumbnail_id = get_post_thumbnail_id(get_the_ID());
	    $image = wp_get_attachment_image_src($post_thumbnail_id, 'localdirectory-blog-thumbnail-img');
	    $author_name = get_the_author_meta('display_name');
	    $category = get_the_category();
	    if (!empty($image)) {
	        $image_style = "style='background-image:url(" . esc_url($image[0]) . ")'";
	    } else {
	        $image_style = '';
	    }
	    if($image){
	        $url = $image[0];
	    }


	    ?>
	    <div class="post-wrap-element">
	        <div class="post-content-wrap">
	        	<?php if ($image) :?>
	            <div class="post-thumb">
	                <img src="<?php echo esc_url($image[0]) ?>">
	            </div>
	            <?php endif; ?>
	            <div class="post-content">

	                <h2>
	                    <a href="<?php echo esc_url(get_the_permalink()); ?>"><?php echo the_title(); ?></a>
	                </h2>
	                <ul class="post-meta">
	                <li class="post-cat">
	            <?php 
	$categories = get_the_category();
	if ( ! empty( $categories ) ) {
	echo '<a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a>';
	}
	            ?>
	        </li>
	                    <li class="meta-date"><a
	                                href="<?php echo esc_url(localdirectory_archive_link($post)); ?>">
	                             <time class="entry-date published"
	                                      datetime="<?php echo esc_url(localdirectory_archive_link($post)); ?>"><?php echo esc_html(the_time( get_option( 'date_format' ) )); ?></time>
	                        </a></li>
	                </ul>

	            </div>
	        </div>
	    </div>
	<?php } else{ ?>
	<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;

		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?php
				localdirectory_posted_on();
				localdirectory_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<?php localdirectory_post_thumbnail(); ?>

	<div class="entry-content">
		<?php
		if (is_archive() || is_home()){
                echo wp_kses_post(localdirectory_get_excerpt($post->ID, 300));
		}
		 else{
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'localdirectory' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			)
		);
		}

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'localdirectory' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<footer class="entry-footer">
		<?php localdirectory_entry_footer(); ?>
	</footer><!-- .entry-footer -->
	<?php } ?>
</article><!-- #post-<?php the_ID(); ?> -->

<?php } ?>
