<?php
/**
 * Localdirectory Theme Customizer
 *
 * @package Localdirectory
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function localdirectory_customize_register( $wp_customize ) {
	$wp_customize->get_setting( 'blogname' )->transport         = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport  = 'postMessage';
	$wp_customize->get_setting( 'header_textcolor' )->transport = 'postMessage';

	$localdirectory_options = localdirectory_theme_options();

	if ( isset( $wp_customize->selective_refresh ) ) {
		$wp_customize->selective_refresh->add_partial(
			'blogname',
			array(
				'selector'        => '.site-title a',
				'render_callback' => 'localdirectory_customize_partial_blogname',
			)
		);
		$wp_customize->selective_refresh->add_partial(
			'blogdescription',
			array(
				'selector'        => '.site-description',
				'render_callback' => 'localdirectory_customize_partial_blogdescription',
			)
		);
	}

	$wp_customize->add_panel(
        'theme_options',
        array(
            'title' => esc_html__('Theme Options', 'localdirectory'),
            'priority' => 2,
        )
    );



//Social Links
    $wp_customize->add_section(
    'social_section',
	    array(
	        'title' => esc_html__( 'Social Links','localdirectory' ),
		     'description' => esc_html__( 'More Social Links are available in Premium Version','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);
	$wp_customize->add_setting('localdirectory_theme_options[fb_url]',
	    array(
	        'type' => 'option',
	        'default' => $localdirectory_options['fb_url'],
	        'sanitize_callback' => 'localdirectory_sanitize_url',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[fb_url]',
	    array(
	        'label' => esc_html__('Facebook Link', 'localdirectory'),
	        'type' => 'text',
	        'section' => 'social_section',
	        'settings' => 'localdirectory_theme_options[fb_url]',
	    )
	);
		$wp_customize->add_setting('localdirectory_theme_options[insta_url]',
	    array(
	        'type' => 'option',
	        'default' => $localdirectory_options['insta_url'],
	        'sanitize_callback' => 'localdirectory_sanitize_url',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[insta_url]',
	    array(
	        'label' => esc_html__('Instagram Link', 'localdirectory'),
	        'type' => 'text',
	        'section' => 'social_section',
	        'settings' => 'localdirectory_theme_options[insta_url]',
	    )
	);
		$wp_customize->add_setting('localdirectory_theme_options[twitter_url]',
	    array(
	        'type' => 'option',
	        'default' => $localdirectory_options['twitter_url'],
	        'sanitize_callback' => 'localdirectory_sanitize_url',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[twitter_url]',
	    array(
	        'label' => esc_html__('Twiiter X Link', 'localdirectory'),
	        'type' => 'text',
	        'section' => 'social_section',
	        'settings' => 'localdirectory_theme_options[twitter_url]',
	    )
	);


    $wp_customize->add_section(
    'article_section',
	    array(
	        'title' => esc_html__( 'Single Article/Blog Page','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[sidebar_show]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['sidebar_show'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[sidebar_show]',
	    array(
	        'label' => esc_html__('Show Sidebar in Single Article?', 'localdirectory'),
	        'type' => 'Checkbox',
	        'section' => 'article_section',

	    )
	);



//Header Section
    $wp_customize->add_section(
    'header_section',
	    array(
	        'title' => esc_html__( 'Header Section','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);


       $wp_customize->add_setting( 'localdirectory_theme_options[header_layout]', array(
          'capability' => 'edit_theme_options',
          'default' => 'header1',
          'sanitize_callback' => 'localdirectory_sanitize_radio',
          'type' => 'option',
    ) );

    $wp_customize->add_control( 'localdirectory_theme_options[header_layout]', array(
          'type' => 'radio',
          'section' => 'header_section', // Add a default or your own section
          'label' => esc_attr( __('Choose Header Layout', 'localdirectory') ),
          'choices' => array(
            'header1' => esc_attr( __('Default Header', 'localdirectory') ),
            'header2' => esc_attr( __('Centered Layout', 'localdirectory') ),
            'header3' => esc_attr( __('Bottom Menu Layout', 'localdirectory') ),
          ),
    ) );


	$wp_customize->add_setting('localdirectory_theme_options[dark_header]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['dark_header'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[dark_header]',
	    array(
	        'label' => esc_html__('Dark Header?', 'localdirectory'),
	        'type' => 'Checkbox',
	        'section' => 'header_section',

	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[header_full_width]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['header_full_width'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[header_full_width]',
	    array(
	        'label' => esc_html__('Full Width?', 'localdirectory'),
	        'type' => 'Checkbox',
	        'section' => 'header_section',

	    )
	);







//Banner section
    $wp_customize->add_section(
    'banner_section',
	    array(
	        'title' => esc_html__( 'Banner Section','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[banner_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['banner_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[banner_title]',
	    array(
	        'label' => esc_html__('Banner Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'banner_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[banner_sub]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['banner_sub'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[banner_sub]',
	    array(
	        'label' => esc_html__('Banner Sub Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'banner_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[banner_image]',
	array(
	    'type' => 'option',
	    'sanitize_callback' => 'esc_url_raw',
	)
	);
	$wp_customize->add_control(
	new WP_Customize_Image_Control(
	    $wp_customize,
	    'localdirectory_theme_options[banner_image]',
	    array(
	        'label' => esc_html__('Add Background Image', 'localdirectory'),
	        'section' => 'banner_section',
	        'settings' => 'localdirectory_theme_options[banner_image]',
	    ))
	);

    //Listing section
	$wp_customize->add_section(
    'listing_section',
	    array(
	        'title' => esc_html__( 'Listing Section','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[listing_sec_show]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['listing_sec_show'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[listing_sec_show]',
	    array(
	        'label' => esc_html__('Show Listing Section', 'localdirectory'),
	        'type' => 'Checkbox',
	        'priority' => 1,
	        'section' => 'listing_section',

	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[listing_sec_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['listing_sec_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[listing_sec_title]',
	    array(
	        'label' => esc_html__('Section Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'listing_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[listing_sec_sub_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['listing_sec_sub_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[listing_sec_sub_title]',
	    array(
	        'label' => esc_html__('Section Sub Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'listing_section',
	        'type' => 'text',
	    )
	);



    //CTA section
	$wp_customize->add_section(
    'cta_section',
	    array(
	        'title' => esc_html__( 'Call to Action Section','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[cta_sec_show]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['cta_sec_show'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[cta_sec_show]',
	    array(
	        'label' => esc_html__('Show CTA Section', 'localdirectory'),
	        'type' => 'Checkbox',
	        'priority' => 1,
	        'section' => 'cta_section',

	    )
	);


	$wp_customize->add_setting('localdirectory_theme_options[cta_sec_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['cta_sec_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[cta_sec_title]',
	    array(
	        'label' => esc_html__('CTA Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'cta_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[cta_sec_sub_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['cta_sec_sub_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[cta_sec_sub_title]',
	    array(
	        'label' => esc_html__('CTA Sub Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'cta_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[cta_btn_text]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['cta_btn_text'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[cta_btn_text]',
	    array(
	        'label' => esc_html__('CTA Button Text', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'cta_section',
	        'type' => 'text',
	    )
	);
	$wp_customize->add_setting('localdirectory_theme_options[cta_button_url]',
	    array(
	        'type' => 'option',
	        'default' => $localdirectory_options['cta_button_url'],
	        'sanitize_callback' => 'localdirectory_sanitize_url',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[cta_button_url]',
	    array(
	        'label' => esc_html__('CTA Button Link', 'localdirectory'),
	        'type' => 'text',
	        'section' => 'cta_section',
	        'settings' => 'localdirectory_theme_options[cta_button_url]',
	    )
	);
	$wp_customize->add_setting('localdirectory_theme_options[cta_image]',
	array(
	    'type' => 'option',
	    'sanitize_callback' => 'esc_url_raw',
	)
	);
	$wp_customize->add_control(
	new WP_Customize_Image_Control(
	    $wp_customize,
	    'localdirectory_theme_options[cta_image]',
	    array(
	        'label' => esc_html__('Add Background Image', 'localdirectory'),
	        'section' => 'cta_section',
	        'settings' => 'localdirectory_theme_options[cta_image]',
	    ))
	);


    //Blog section
	$wp_customize->add_section(
    'blog_section',
	    array(
	        'title' => esc_html__( 'Blog Section','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[blog_sec_show]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['blog_sec_show'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[blog_sec_show]',
	    array(
	        'label' => esc_html__('Show Blog Section', 'localdirectory'),
	        'type' => 'Checkbox',
	        'priority' => 1,
	        'section' => 'blog_section',

	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[blog_sec_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['blog_sec_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[blog_sec_title]',
	    array(
	        'label' => esc_html__('Section Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'blog_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[blog_sec_sub_title]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['blog_sec_sub_title'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[blog_sec_sub_title]',
	    array(
	        'label' => esc_html__('Section Sub Title', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'blog_section',
	        'type' => 'text',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[blog_post_no]',
	    array(
	        'capability' => 'edit_theme_options',
	        'default' => $localdirectory_options['blog_post_no'],
	        'sanitize_callback' => 'sanitize_text_field',
	        'type' => 'option',
	    )
	);
	$wp_customize->add_control('localdirectory_theme_options[blog_post_no]',
	    array(
	        'label' => esc_html__('No Of Blog Posts to show?', 'localdirectory'),
	        'priority' => 1,
	        'section' => 'blog_section',
	        'type' => 'text',
	    )
	);



	$wp_customize->add_section(
    'footer_section',
	    array(
	        'title' => esc_html__( 'Footer Option','localdirectory' ),
	       	'description' => esc_html__( 'Copyright text can be changed in Premium Version','localdirectory' ),
	        'panel'=>'theme_options',
	        'capability'=>'edit_theme_options',
	    )
	);

	$wp_customize->add_setting('localdirectory_theme_options[show_widgets]',
	    array(
	        'type' => 'option',
	        'default'        => true,
	        'default' => $localdirectory_options['show_widgets'],
	        'sanitize_callback' => 'localdirectory_sanitize_checkbox',
	    )
	);

	$wp_customize->add_control('localdirectory_theme_options[show_widgets]',
	    array(
	        'label' => esc_html__('Show Widgets', 'localdirectory'),
	        'type' => 'Checkbox',
	        'priority' => 1,
	        'section' => 'footer_section',

	    )
	);


}
add_action( 'customize_register', 'localdirectory_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function localdirectory_customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function localdirectory_customize_partial_blogdescription() {
	bloginfo( 'description' );
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 */
function localdirectory_customize_preview_js() {
	wp_enqueue_script( 'localdirectory-customizer', get_template_directory_uri() . '/js/customizer.js', array( 'customize-preview' ), '20151215', true );
}
add_action( 'customize_preview_init', 'localdirectory_customize_preview_js' );
