<?php
/**
 * Breadcrumb settings
 */

$wp_customize->add_section(
	'express_news_breadcrumb_section',
	array(
		'title' => esc_html__( 'Breadcrumb Options', 'express-news' ),
		'panel' => 'express_news_theme_options_panel',
	)
);

// Breadcrumb enable setting.
$wp_customize->add_setting(
	'express_news_breadcrumb_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_breadcrumb_enable',
		array(
			'label'    => esc_html__( 'Enable breadcrumb.', 'express-news' ),
			'type'     => 'checkbox',
			'settings' => 'express_news_breadcrumb_enable',
			'section'  => 'express_news_breadcrumb_section',
		)
	)
);

// Breadcrumb - Separator.
$wp_customize->add_setting(
	'express_news_breadcrumb_separator',
	array(
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => '/',
	)
);

$wp_customize->add_control(
	'express_news_breadcrumb_separator',
	array(
		'label'           => esc_html__( 'Separator', 'express-news' ),
		'section'         => 'express_news_breadcrumb_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'express_news_breadcrumb_enable' )->value() );
		},
	)
);
