<?php

/**
 * Adore Themes Customizer
 *
 * @package Express News
 *
 * Banner Section
 */

$wp_customize->add_section(
	'express_news_banner_section',
	array(
		'title'    => esc_html__( 'Banner Section', 'express-news' ),
		'panel'    => 'express_news_frontpage_panel',
		'priority' => 20,
	)
);

// Banner enable setting.
$wp_customize->add_setting(
	'express_news_banner_section_enable',
	array(
		'default'           => false,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_banner_section_enable',
		array(
			'label'    => esc_html__( 'Enable Banner Section', 'express-news' ),
			'type'     => 'checkbox',
			'settings' => 'express_news_banner_section_enable',
			'section'  => 'express_news_banner_section',
			'priority' => 10,
		)
	)
);

// Banner Posts Sub Heading.
$wp_customize->add_setting(
	'express_news_banner_posts_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Express_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'express_news_banner_posts_sub_heading',
		array(
			'label'           => esc_html__( 'Banner Posts Section', 'express-news' ),
			'settings'        => 'express_news_banner_posts_sub_heading',
			'section'         => 'express_news_banner_section',
			'active_callback' => 'express_news_if_banner_enabled',
			'priority' => 20,
		)
	)
);

// Banner Posts post setting.
$wp_customize->add_setting(
	'express_news_banner_posts_post',
	array(
		'sanitize_callback' => 'express_news_sanitize_dropdown_pages',
	)
);

$wp_customize->add_control(
	'express_news_banner_posts_post',
	array(
		'label'           => esc_html__( 'Post', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'type'            => 'select',
		'choices'         => express_news_get_post_choices(),
		'active_callback' => 'express_news_if_banner_enabled',
		'priority' => 30,
	)
);

// Banner posts excerpt length setting.
$wp_customize->add_setting(
	'express_news_banner_posts_excerpt_length',
	array(
		'default'           => 120,
		'sanitize_callback' => 'express_news_sanitize_number_range',
	)
);

$wp_customize->add_control(
	'express_news_banner_posts_excerpt_length',
	array(
		'label'           => esc_html__( 'Banner Posts Excerpt Length:', 'express-news' ),
		'description'     => esc_html__( 'Min: 1', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'type'            => 'number',
		'input_attrs'     => array(
			'min' => 1,
		),
		'active_callback' => 'express_news_if_banner_enabled',
		'priority' => 40,
	)
);

// Related Posts title settings.
$wp_customize->add_setting(
	'express_news_banner_posts_related_posts_title',
	array(
		'default'           => __( 'Related Posts', 'express-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'express_news_banner_posts_related_posts_title',
	array(
		'label'           => esc_html__( 'Related Posts Title Label', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'active_callback' => 'express_news_if_banner_enabled',
		'priority' => 50,
	)
);

// Abort if selective refresh is not available.
if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'express_news_banner_posts_related_posts_title',
		array(
			'selector'            => '.banner-related-posts-section h3.related-title',
			'settings'            => 'express_news_banner_posts_related_posts_title',
			'container_inclusive' => false,
			'fallback_refresh'    => true,
		)
	);
}

// Banner Posts related posts settings.
$wp_customize->add_setting(
	'express_news_banner_posts_related_posts_orderby',
	array(
		'default'           => 'date',
		'sanitize_callback' => 'express_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'express_news_banner_posts_related_posts_orderby',
	array(
		'label'           => esc_html__( 'Related Posts Orderby:', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'settings'        => 'express_news_banner_posts_related_posts_orderby',
		'type'            => 'select',
		'active_callback' => 'express_news_if_banner_enabled',
		'choices'         => array(
			'date' => esc_html__( 'Date', 'express-news' ),
			'rand' => esc_html__( 'Random', 'express-news' ),
		),
		'priority' => 60,
	)
);

// Posts Tab Sub Heading.
$wp_customize->add_setting(
	'express_news_posts_tab_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Express_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'express_news_posts_tab_sub_heading',
		array(
			'label'           => esc_html__( 'Posts Tab Section', 'express-news' ),
			'settings'        => 'express_news_posts_tab_sub_heading',
			'section'         => 'express_news_banner_section',
			'active_callback' => 'express_news_if_banner_enabled',
			'priority' => 70,
		)
	)
);

// Latest News Tab Enable.
$wp_customize->add_setting(
	'express_news_latest_news_tab_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_latest_news_tab_enable',
		array(
			'label'           => esc_html__( 'Enable Latest News Tab', 'express-news' ),
			'type'            => 'checkbox',
			'settings'        => 'express_news_latest_news_tab_enable',
			'section'         => 'express_news_banner_section',
			'active_callback' => 'express_news_if_banner_enabled',
			'priority' => 80,
		)
	)
);

// Latest News Tab title settings.
$wp_customize->add_setting(
	'express_news_latest_news_tab_title',
	array(
		'default'           => __( 'Latest News', 'express-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'express_news_latest_news_tab_title',
	array(
		'label'           => esc_html__( 'Latest News Title Label', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'express_news_latest_news_tab_enable' )->value() );
		},
		'priority' => 90,
	)
);

// Random News Tab Enable.
$wp_customize->add_setting(
	'express_news_random_news_tab_enable',
	array(
		'default'           => true,
		'sanitize_callback' => 'express_news_sanitize_checkbox',
	)
);

$wp_customize->add_control(
	new Express_News_Toggle_Checkbox_Custom_control(
		$wp_customize,
		'express_news_random_news_tab_enable',
		array(
			'label'           => esc_html__( 'Enable Random News Tab', 'express-news' ),
			'type'            => 'checkbox',
			'settings'        => 'express_news_random_news_tab_enable',
			'section'         => 'express_news_banner_section',
			'active_callback' => 'express_news_if_banner_enabled',
			'priority' => 100,
		)
	)
);

// Random News Tab title settings.
$wp_customize->add_setting(
	'express_news_random_news_tab_title',
	array(
		'default'           => __( 'Random News', 'express-news' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'express_news_random_news_tab_title',
	array(
		'label'           => esc_html__( 'Random News Title Label', 'express-news' ),
		'section'         => 'express_news_banner_section',
		'active_callback' => function( $control ) {
			return ( $control->manager->get_setting( 'express_news_random_news_tab_enable' )->value() );
		},
		'priority' => 110,
	)
);

/*========================Active Callback==============================*/
function express_news_if_banner_enabled( $control ) {
	return $control->manager->get_setting( 'express_news_banner_section_enable' )->value();
}
