<?php
/**
 * Title: Why Choose Us
 * Slug: ev-charging-station/why-choose-us
 * Categories: ev-charging-station
 * Keywords: why-choose-us
 * Block Types: core/post-content
 * Post Types: page, wp_template
 */
?>
<!-- wp:group {"metadata":{"name":"Why Choose Us"},"className":"choose-section","style":{"spacing":{"padding":{"right":"0px","left":"0px"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group choose-section" style="padding-right:0px;padding-left:0px"><!-- wp:cover {"url":"<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/choose-bg.png","id":22,"dimRatio":90,"overlayColor":"contrast","isUserOverlayColor":true,"sizeSlug":"full","className":"choose-bg","style":{"border":{"radius":"20px"},"spacing":{"padding":{"right":"0px","left":"0px","top":"50px","bottom":"50px"}}},"layout":{"type":"constrained","contentSize":"80%"}} -->
<div class="wp-block-cover choose-bg" style="border-radius:20px;padding-top:50px;padding-right:0px;padding-bottom:50px;padding-left:0px"><img class="wp-block-cover__image-background wp-image-22 size-full" alt="" src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/choose-bg.png" data-object-fit="cover"/><span aria-hidden="true" class="wp-block-cover__background has-contrast-background-color has-background-dim-90 has-background-dim"></span><div class="wp-block-cover__inner-container"><!-- wp:columns {"className":"choose-cont-boxes","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|30"}}}} -->
<div class="wp-block-columns choose-cont-boxes"><!-- wp:column {"className":"choose-content wow fadeInDown"} -->
<div class="wp-block-column choose-content wow fadeInDown"><!-- wp:group {"className":"choose-inner-content","style":{"spacing":{"padding":{"right":"18rem"}}},"layout":{"type":"default"}} -->
<div class="wp-block-group choose-inner-content" style="padding-right:18rem"><!-- wp:heading {"textAlign":"left","style":{"typography":{"fontSize":"20px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","textDecoration":"underline"},"elements":{"link":{"color":{"text":"var:preset|color|primary"}}}},"textColor":"primary","fontFamily":"heading"} -->
<h2 class="wp-block-heading has-text-align-left has-primary-color has-text-color has-link-color has-heading-font-family" style="font-size:20px;font-style:normal;font-weight:500;text-decoration:underline;text-transform:capitalize"><?php echo esc_html__( 'why choose us', 'ev-charging-station' ); ?></h2>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"typography":{"fontSize":"23px","textTransform":"capitalize"},"spacing":{"margin":{"top":"12px"}}},"textColor":"base-2"} -->
<p class="has-text-align-left has-base-2-color has-text-color has-link-color" style="margin-top:12px;font-size:23px;text-transform:capitalize"><?php echo esc_html__( 'what makes us different', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"typography":{"fontSize":"35px","lineHeight":"1.3"},"spacing":{"margin":{"top":"15px"}}},"textColor":"base-2"} -->
<p class="has-text-align-left has-base-2-color has-text-color has-link-color" style="margin-top:15px;font-size:35px;line-height:1.3"><?php echo esc_html__( 'We’re more than just a plug point.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"align":"left","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"typography":{"fontSize":"13px"}},"textColor":"base-2"} -->
<p class="has-text-align-left has-base-2-color has-text-color has-link-color" style="font-size:13px"><?php echo esc_html__( 'Our network is designed for universality and scalability — compatible with all types of EVs, equipped with smart sensors, and backed by real-time station data through our mobile app. We’re more than just a charging station — we’re a clean energy ecosystem made for the modern EV lifestyle.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"choose-card-boxes"} -->
<div class="wp-block-column choose-card-boxes"><!-- wp:columns {"className":"choose-card-inner-box","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|30"}}}} -->
<div class="wp-block-columns choose-card-inner-box"><!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":47,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img1.png" alt="" class="wp-image-47" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( 'fast & efficient charging', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'With cutting-edge fast-charging technology, VoltNest ensures your vehicle is powered up in the shortest possible time so you\'re back on the road quickly.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":94,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img2.png" alt="" class="wp-image-94" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( '24/7 customer support', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'Day or night, our support team is here for you via live chat, phone, and app support — because EV reliability starts with human support.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"className":"choose-card-inner-box","style":{"spacing":{"blockGap":{"left":"var:preset|spacing|30"},"margin":{"top":"40px"}}}} -->
<div class="wp-block-columns choose-card-inner-box" style="margin-top:40px"><!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":96,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img3.png" alt="" class="wp-image-96" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( 'universal charging connectors', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'VoltNest supports all major EV brands and connector types — from two-wheelers to sedans, SUVs, and e-rickshaws. No compatibility issues, ever.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":97,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img4.png" alt="" class="wp-image-97" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( 'smart & contactless access', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'Access any VoltNest station with a simple QR scan, monitor charging status in real-time, and complete payments securely, all through the VoltNest app.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":98,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img5.png" alt="" class="wp-image-98" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( 'live charging station availability', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'Our stations are connected in real-time. Check availability, reserve slots, and avoid queues — plan your charge with confidence.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"choose-card wow zoomIn"} -->
<div class="wp-block-column choose-card wow zoomIn"><!-- wp:group {"className":"choose-card-cont","style":{"border":{"radius":"20px"},"spacing":{"padding":{"top":"20px","bottom":"45px","left":"12px","right":"12px"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-cont has-base-2-background-color has-background" style="border-radius:20px;padding-top:20px;padding-right:12px;padding-bottom:45px;padding-left:12px"><!-- wp:group {"className":"choose-card-img-bg","style":{"spacing":{"margin":{"top":"20px","bottom":"35px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group choose-card-img-bg" style="margin-top:20px;margin-bottom:35px"><!-- wp:image {"id":99,"width":"auto","height":"38px","sizeSlug":"full","linkDestination":"none","align":"center"} -->
<figure class="wp-block-image aligncenter size-full is-resized"><img src="<?php echo esc_url( get_template_directory_uri() ); ?>/assets/images/card-img6.png" alt="" class="wp-image-99" style="width:auto;height:38px"/></figure>
<!-- /wp:image --></div>
<!-- /wp:group -->

<!-- wp:heading {"textAlign":"center","level":5,"className":"card-title","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"typography":{"fontSize":"18px","textTransform":"capitalize","fontStyle":"normal","fontWeight":"500","lineHeight":"1.5"},"spacing":{"padding":{"right":"40px","left":"40px"}}},"textColor":"contrast","fontFamily":"heading"} -->
<h5 class="wp-block-heading has-text-align-center card-title has-contrast-color has-text-color has-link-color has-heading-font-family" style="padding-right:40px;padding-left:40px;font-size:18px;font-style:normal;font-weight:500;line-height:1.5;text-transform:capitalize"><?php echo esc_html__( 'green energy grid', 'ev-charging-station' ); ?></h5>
<!-- /wp:heading -->

<!-- wp:paragraph {"align":"center","style":{"typography":{"fontSize":"12px","fontStyle":"normal","fontWeight":"400"},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
<p class="has-text-align-center has-contrast-color has-text-color has-link-color" style="font-size:12px;font-style:normal;font-weight:400"><?php echo esc_html__( 'VoltNest stations are integrated with solar or green-certified energy sources to minimize environmental impact while supporting sustainable transport.', 'ev-charging-station' ); ?></p>
<!-- /wp:paragraph -->

<!-- wp:buttons {"className":"card-btn","layout":{"type":"flex","justifyContent":"center"}} -->
<div class="wp-block-buttons card-btn"><!-- wp:button {"backgroundColor":"primary","textColor":"base-2","style":{"elements":{"link":{"color":{"text":"var:preset|color|base-2"}}},"border":{"radius":"100px","width":"2px"},"spacing":{"padding":{"left":"6px","right":"6px","top":"4px","bottom":"4px"}},"typography":{"fontSize":"22px"}},"borderColor":"contrast"} -->
<div class="wp-block-button"><a class="wp-block-button__link has-base-2-color has-primary-background-color has-text-color has-background has-link-color has-border-color has-contrast-border-color has-custom-font-size wp-element-button" href="#" style="border-width:2px;border-radius:100px;padding-top:4px;padding-right:6px;padding-bottom:4px;padding-left:6px;font-size:22px"><i class="fa-solid fa-arrow-right"></i></a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:group --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div></div>
<!-- /wp:cover --></div>
<!-- /wp:group -->

<!-- wp:spacer {"height":"60px"} -->
<div style="height:60px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->