<?php
/**
 * Citykid Starter Content
 *
 * @link https://make.wordpress.org/core/2016/11/30/starter-content-for-themes-in-4-7/
 *
 * @package WordPress
 * @subpackage Citykid
 * @since Citykid 1.0.0
 */

 

/**
 * Function to return the array of starter content for the theme.
 *
 * Passes it through the `tcitykid_starter_content` filter before returning.
 *
 * @since Twenty Twenty-One 1.0
 *
 * @return array A filtered array of args for the starter_content.
 */
function citykid_get_starter_content() {

	// Define and register starter content to showcase the theme on new sites.
	$starter_content = array(

		// Specify the core-defined pages to create and add custom thumbnails to some of them.
		'posts'     => array(
			'front' => array(
				'post_type'    => 'page',
				'post_title'   => esc_html_x( 'Home', 'Theme starter content', 'citykid' ),
				'post_content' => include __DIR__.'/starter-content/front.php',
				'meta_input' => [
					'tra_header' => true,
					'disable_banner' => true,
					'container' => 'container-full',
					'spacer_y' => 'py-0'
				],
				'template' => 'templates/full-width.php',
				
			),
			'about',
			'listings' => array(
				'post_type' => 'page',
				'post_title' => _x( 'Our Listings', 'Theme starter content', 'citykid' ),
			),
			'contact',
			'blog' => array(
				'post_type' => 'page',
				'post_title' => _x( 'Latest News', 'Theme starter content', 'citykid' ),
			),
			'help' => array(
				'post_type' => 'page',
				'post_title' => _x( 'Help', 'Theme starter content', 'citykid' ),
			),
			'tell-a-friend' => array(
				'post_type' => 'page',
				'post_title' => _x( 'Tell a friend', 'Theme starter content', 'citykid' ),
			),
		),		

		'attachments' => array(
			'favicon' => array(
				'post_title' => _x('Stories favicon', 'Theme starter content', 'citykid'),
				'file' => 'assets/images/favicon.png'
			),
			'logo' => array(
				'post_title' => _x('Stories Logo', 'Theme starter content', 'citykid'),
				'file' => 'assets/images/logo.png'
			),
			'logo-white' => array(
				'post_title' => _x('Stories Logo white', 'Theme starter content', 'citykid'),
				'file' => 'assets/images/logo-white.png'
			),
			'banner-image' => array(
				'post_title' => _x( 'Banner', 'Theme starter content', 'citykid' ),
				'file' => 'assets/images/about-img.jpg'
			),
			'hero-image' => array(
				'post_title' => _x( 'Hero Banner', 'Theme starter content', 'citykid' ),
				'file' => 'assets/images/advance-search-bg.jpg'
			),
		),

		'widgets' => array(
			'footer-widget-1' => array(
				'text_sidebar' => array(
					'text',
					array(
						'title' => esc_html_x( 'About CityKid', 'Theme starter content', 'citykid' ),
						'text'  => esc_html_x( 'Got kids? Don\'t know what to do? Explore New York for fun things to do with the kids. Explore NY kids\' website for calendar, fun things to do, kids\' activities, birthday parties, entertainers, camps, & more!', 'Theme starter content', 'citykid' )
					),
				),
			),
			'footer-widget-2' => array(
				'recent-posts'
			),
			'footer-widget-3' => array(
				'categories'
			),
			'footer-widget-4' => array(
				'text_business_info'
			),
			'footer-widget-5' => array(
				'meta'
			),
		),

		// Default to a static front page and assign the front and posts pages.
		'options'   => array(
			'show_on_front'  => 'page',
			'page_on_front'  => '{{front}}',
			'page_for_posts' => '{{blog}}',
			'blogdescription' => 'New York best after school kids activities directory listing WP theme'
		),

		// set theme mods
		'theme_mods'   => array(
			'site_icon'  => '{{favicon}}',
			'custom_logo'  => '{{logo}}',
			'custom_logo_white'  => '{{logo-white}}',
			'footer_logo'  => '{{logo-white}}',
			'banner_image'  => '{{banner-image}}',
			'enable_header_search' => false,
			'nav_button_text' => 'Add listing'
		),

		// Set up nav menus for each of the two areas registered in the theme.
		'nav_menus' => array(
			// Assign a menu to the "primary" location.
			'primary' => array(
				'name'  => esc_html__( 'Primary menu', 'citykid' ),
				'items' => array(
					'link_home', // Note that the core "home" page is actually a link in case a static front page is not used.					
					'page_listings' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{listings}}',
					 ),
					 'page_about',
					'page_blog',
					'page_contact',
				),
			),

			// Assign a menu to the "topbar" location.
			'topbar' => array(
				'name'  => esc_html__( 'Topbar menu', 'citykid' ),
				'items' => array(
					'page_about', // Note that the core "home" page is actually a link in case a static front page is not used.
					'page_help' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{help}}',
					),
					'page_tell-a-friend' => array(
						'type' => 'post_type',
						'object' => 'page',
						'object_id' => '{{tell-a-friend}}',
					),
				),
			),

			'social' => array(
				'name'  => esc_html__( 'Topbar social menu', 'citykid' ),
				'items' => array(
					'link_facebook', // Note that the core "home" page is actually a link in case a static front page is not used.
					'link_instagram',
					'link_twitter',
				),
			),

			// Assign a menu to the "footer" location.
			'for_parent_menu'  => array(
				'name'  => esc_html__( 'For parent', 'citykid' ),
				'items' => array(
					'link_terms'  =>  array(
						'title' =>  _x( 'Parents FAQs', 'Theme starter content', 'citykid' ),
						'url'   =>  '#',
					),
					'link_policy'  =>  array(
						'title' =>  _x( 'Citykid Blog', 'Theme starter content', 'citykid' ),
						'url'   =>  '#',
					),
					'link_disclaimer'  =>  array(
						'title' =>  _x( 'Free Events', 'Theme starter content', 'citykid' ),
						'url'   =>  '#',
					),
					'link_sitemap'  =>  array(
						'title' =>  _x( 'Holiday Events', 'Theme starter content', 'citykid' ),
						'url'   =>  '#',
					),
					'link_sitemap'  =>  array(
						'title' =>  _x( 'Weekend Events', 'Theme starter content', 'citykid' ),
						'url'   =>  '#',
					),
					
				),
			),
			'footer'  => array(
				'name'  => esc_html__( 'Secondary menu', 'citykid' ),
				'items' => array(
					'link_terms'  =>  array(
						'title' =>  _x( 'Terms of use', 'Theme starter content', 'citykid' ),
						'url'   =>  home_url( '#' ),
					),
					'link_policy'  =>  array(
						'title' =>  _x( 'Privacy policy', 'Theme starter content', 'citykid' ),
						'url'   =>  home_url( '#' ),
					),
					'link_disclaimer'  =>  array(
						'title' =>  _x( 'Disclaimer', 'Theme starter content', 'citykid' ),
						'url'   =>  home_url( '#' ),
					),
					'link_sitemap'  =>  array(
						'title' =>  _x( 'Site Map', 'Theme starter content', 'citykid' ),
						'url'   =>  home_url( '#' ),
					),
					
				),
			),

			'footer_social' => array(
				'name'  => esc_html__( 'Footer social menu', 'citykid' ),
				'items' => array(
					'link_facebook', // Note that the core "home" page is actually a link in case a static front page is not used.
					'link_instagram',
					'link_twitter',
					'link_linkedin',
					'link_github',
				),
			),
		),
	);

	/**
	 * Filters the array of starter content.
	 *
	 * @since Twenty Twenty-One 1.0
	 *
	 * @param array $starter_content Array of starter content.
	 */
	return $starter_content;
}

/**
 * Add postmeta to starter content posts
 * @param  array $content  the starter content array
 * @param  [type] $config  [description]
 * @return [type]          [description]
 */
function citykid_starter_content_add_postmeta( $content, $config ) {

	// bail if not a fresh site
	if ( false === get_option( 'fresh_site' ) ) {
		return;
	}
	
	$pages = $config['posts'];

	if ( $pages && is_array( $pages ) ) {
		
		foreach ($pages as $key => $page) {
			if(empty($page['meta_input'])) continue;
			$content['posts'][$key]['meta_input'] = $page['meta_input'];
		}
		
	}

    return $content;
}
add_filter( 'get_theme_starter_content', 'citykid_starter_content_add_postmeta', 10, 2 );