<?php
add_filter( 'control_listings/template_directory', 'control_listings_template_directory' );
function control_listings_template_directory(){
    return '/template-parts/listings/';
}

add_action('control_listing_content_before', 'citykid_control_listing_content_before');
function citykid_control_listing_content_before(){
    
    if(get_query_var('view') == 'map'){
        get_template_part('template-parts/listings/before', 'map');
    }else{
        get_template_part('template-parts/header/banner', get_post_type());
            if( function_exists('control_listing_map_template') && get_query_var('view') != 'map' ){
            control_listing_map_template();
        }
        get_template_part('template-parts/content/before');
    }
    
    
	do_action('citykid_content_before');
}

add_action('control_listing_single_content_before', 'citykid_control_listing_single_content_before', 2);
function citykid_control_listing_single_content_before(){
    $banner_args = [
        'disable_banner' => true, 
        'breadcrumbs_bg' => ''
    ];
    get_template_part('template-parts/header/banner', get_post_type(), $banner_args);
}

add_action('control_listing_single_content_before', 'citykid_control_listing_single_after_title', 11);
function citykid_control_listing_single_after_title(){
    
    get_template_part('template-parts/content/before', get_post_type(), ['spacer_y' => 'pb-100']);
	do_action('citykid_content_before');
}

add_action('control_listing_content_after', 'citykid_control_listing_content_after');
add_action('control_listing_single_content_after', 'citykid_control_listing_content_after');
function citykid_control_listing_content_after(){
    do_action('citykid_content_after');
    if(get_query_var('view') == 'map'){
        get_template_part('template-parts/listings/after', 'map');
    }else{
        get_template_part('template-parts/content/after');
    }
}


if(!function_exists('control_listings_login_link')):
/**
 * 
 * @param 	string		$title			(optional)
 * @param 	string		$link_text		login
 * @param 	string		$class			empty
 * 
 * @return	string	
*/
function control_listings_login_link($title, $link_text = 'login', $class = ''){
    $classes = [
        'ctrl-listing-login-link',
        $class
    ];
    return '<a href="#citikidLoginModal"  data-bs-toggle="modal" data-title="'.esc_attr($title).'" class="'.implode(' ', array_filter($classes)).'">'.$link_text.'</a>';
}
endif;
