<?php
include __DIR__.'/control-listings.php';
include __DIR__.'/demo-data.php';

/**
 * Register widget area.
 *
 * @since citykid 1.0
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 *
 * @return void
 */
function citykid_widgets_init() {

	register_sidebar(
		array(
			'name'          => esc_html__( 'Main widget area', 'citykid' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here to appear in your sidebar.', 'citykid' ),
			'before_widget' => '<div id="%1$s" class="card card-widget %2$s"><div class="card-body widget">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

    register_sidebar(
		array(
			'name'          => esc_html__( 'Page widget area', 'citykid' ),
			'id'            => 'sidebar-page',
			'description'   => esc_html__( 'Add widgets here to appear in your page sidebar.', 'citykid' ),
			'before_widget' => '<div id="%1$s" class="card card-widget %2$s"><div class="card-body widget">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);

    if( defined('CTRL_LISTINGS_VER') ):
    register_sidebar(
		array(
			'name'          => esc_html__( 'Listing widget area', 'citykid' ),
			'id'            => 'sidebar-listings',
			'description'   => esc_html__( 'Add widgets here to appear in your listing sidebar.', 'citykid' ),
			'before_widget' => '<div id="%1$s" class="card card-widget %2$s"><div class="card-body widget">',
			'after_widget'  => '</div></div>',
			'before_title'  => '<h4 class="widget-title">',
			'after_title'   => '</h4>',
		)
	);
    endif;
}
add_action( 'widgets_init', 'citykid_widgets_init' );


function citykid_get_meta_values( $key = '', $type = 'post', $status = 'publish' ) {
    
    global $wpdb;
    
    if( empty( $key ) )
        return;
    
    $r = $wpdb->get_col( $wpdb->prepare( "
        SELECT pm.meta_value FROM {$wpdb->postmeta} pm
        LEFT JOIN {$wpdb->posts} p ON p.ID = pm.post_id
        WHERE pm.meta_key = %s 
        AND p.post_status = %s 
        AND p.post_type = %s
    ", $key, $status, $type ) );
    
    return $r;
}

add_action('enqueue_block_editor_assets', 'citykid_enqueue_block_editor_assets');
function citykid_enqueue_block_editor_assets(){    
    wp_enqueue_style('citykid-editor', get_theme_file_uri('assets/css/citykid-editor.css'), [], '1.0.0');
    
    wp_enqueue_script('citykid-editor', CITYKID_ASSETS .'/js/admin/citykid-editor.js', ['jquery'], '5.0.0', true);
    $l10n = [
        'margin' => citykid_get_spacer_options('mb-', 'Margin bottom '),
        'gutterX' => citykid_get_spacer_options('gx-', 'Horizontal Gutter '),
        'gutterY' => citykid_get_spacer_options('gy-', 'Vertical Gutter '),
        'padding' => citykid_get_spacer_options('p-', 'Padding '),
        'colors' => citykid_get_editor_color_choices(),
        'columnTemplates' => citykid_get_editor_column_templates()
    ];
    wp_localize_script( 'citykid-editor', 'citykidEditor', $l10n );
}

add_action('admin_enqueue_scripts', 'citykid_admin_enqueue_scripts');
function citykid_admin_enqueue_scripts(){
    wp_enqueue_style('citykid-admin', CITYKID_ASSETS .'/css/admin/citykid-admin.css', [], '1.0.0');
    wp_enqueue_script('citykid-admin', CITYKID_ASSETS. '/js/admin/citykid-admin.js', ['jquery'], '5.0.0', true);   
    
}