<?php
/**
 * Template part for displaying best deals section
 *
 * @package Car Rental Hub
 * @subpackage car_rental_hub
 */
?>
<?php $car_rental_hub_static_image = get_template_directory_uri() . '/assets/images/sliderimage.png'; ?>

<?php if ( get_theme_mod( 'car_rental_hub_featured_car_show_hide',true ) ) { ?>
<section id="featured-car" class="py-5">
  <div class="container">
    <div class="row">
      <?php
        $automobile_hub_post_category = get_theme_mod( 'car_rental_hub_featured_car_section_category' );
        $car_rental_hub_num_posts = get_theme_mod( 'car_rental_hub_num_posts', 3 ); 
        if ( $automobile_hub_post_category ) {
          $automobile_hub_page_query = new WP_Query(array( 
            'category_name' => esc_html( $automobile_hub_post_category ),
            'posts_per_page' => absint( $car_rental_hub_num_posts ),
          ));

          $post_index = 1;

          while ( $automobile_hub_page_query->have_posts() ) : $automobile_hub_page_query->the_post(); ?>
            <div class="col-lg-4 col-md-6">
              <div class="cat-inner-box mb-4">
                <?php if ( has_post_thumbnail() ) { ?>
                  <?php the_post_thumbnail(); ?>
                <?php } else { ?>
                  <img src="<?php echo esc_url( $car_rental_hub_static_image ); ?>" alt="Default Image">
                <?php } ?>
                <?php if ( get_theme_mod('car_rental_hub_body_type' . $post_index) || 
                           get_theme_mod('car_rental_hub_model_year' . $post_index) || 
                           get_theme_mod('car_rental_hub_mileage' . $post_index) ) { ?>
                  <div class="featured-car-box">
                    <div class="row">
                      <div class="col-lg-4 col-md-4 col-4 align-self-center">
                        <?php
                          $car_rental_hub_body_type = get_theme_mod( 'car_rental_hub_body_type' . $post_index );
                          if ( ! empty( $car_rental_hub_body_type ) ) : ?>
                            <p class="mb-0 border-white"><i class="fas fa-car me-2"></i><?php echo esc_html( $car_rental_hub_body_type ); ?></p>
                        <?php endif; ?>
                      </div>
                      <div class="col-lg-4 col-md-4 col-4 align-self-center">
                        <?php
                          $car_rental_hub_model_year = get_theme_mod( 'car_rental_hub_model_year' . $post_index );
                          if ( ! empty( $car_rental_hub_model_year ) ) : ?>
                            <p class="mb-0 border-white"><i class="fas fa-calendar-alt me-2"></i><?php echo esc_html( $car_rental_hub_model_year ); ?></p>
                        <?php endif; ?>
                      </div>
                      <div class="col-lg-4 col-md-4 col-4 align-self-center">
                        <?php
                          $car_rental_hub_mileage = get_theme_mod( 'car_rental_hub_mileage' . $post_index );
                          if ( ! empty( $car_rental_hub_mileage ) ) : ?>
                            <p class="mb-0"><i class="fas fa-road me-2"></i><?php echo esc_html( $car_rental_hub_mileage ); ?></p>
                        <?php endif; ?>
                      </div>
                    </div>
                  </div>
                <?php } ?>
                <div class="car-inner-content">
                  <div class="row">
                    <div class="col-lg-7 col-md-7 align-self-center">
                      <h3 class="mb-0"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
                    </div>
                    <div class="col-lg-5 col-md-5 align-self-center">
                      <?php
                        $car_rental_hub_compare_price = get_theme_mod( 'car_rental_hub_compare_price' . $post_index );
                        if ( ! empty( $car_rental_hub_compare_price ) ) : ?>
                            <p class="cours-price mb-0"><?php echo esc_html( $car_rental_hub_compare_price ); ?></p>
                      <?php endif; ?>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          <?php
            $post_index++;
          endwhile;
          wp_reset_postdata();
        }
      ?>
    </div>
  </div>
</section>
<?php } ?>
