<?php
function auto_dealer_lite_remove_customize_register() {
    global $wp_customize;
    
    $wp_customize->remove_setting( 'automobile_hub_menu_font_size' );
    $wp_customize->remove_control( 'automobile_hub_menu_font_size' );

    $wp_customize->remove_setting( 'automobile_hub_tp_color_option_link' );
    $wp_customize->remove_control( 'automobile_hub_tp_color_option_link' );

    $wp_customize->remove_section('automobile_hub_social_media');
}
add_action( 'customize_register', 'auto_dealer_lite_remove_customize_register', 11 );

if ( ! defined( 'AUTO_DEALER_LITE_TEXT' ) ) {
    define( 'AUTO_DEALER_LITE_TEXT', __( 'Auto Dealer Lite Pro','auto-dealer-lite' ));
}
if ( ! defined( 'AUTO_DEALER_LITE_BUY_TEXT' ) ) {
    define( 'AUTO_DEALER_LITE_BUY_TEXT', __( 'Upgrade Pro','auto-dealer-lite' ));
}


add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( Automobile_Hub_Button::class );

    $manager->add_section(
        new Automobile_Hub_Button( $manager, 'automobile_hub_pro', [
            'title'       => esc_html( AUTO_DEALER_LITE_TEXT,'auto-dealer-lite' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'auto-dealer-lite' ),
            'button_url'  => esc_url( AUTOMOBILE_HUB_PRO_THEME_URL )
        ] )
    );

} );

function auto_dealer_lite_customize_register( $wp_customize ) {
	// Register the custom control type.
	$wp_customize->register_control_type( 'Auto_Dealer_Lite_Toggle_Control' );

	// Pro Version
    class auto_dealer_lite_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( AUTO_DEALER_LITE_BUY_TEXT,'auto-dealer-lite' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function auto_dealer_lite_sanitize_custom_control( $input ) {
        return $input;
    }

	$wp_customize->add_section( 'auto_dealer_lite_featured_car_section' , array(
		'title'      => __( 'Featured Car Settings', 'auto-dealer-lite' ),
		'panel'      => 'automobile_hub_panel_id',
		'priority'   => 4,
	) );

	$wp_customize->add_setting( 'auto_dealer_lite_featured_car_show_hide', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'automobile_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Auto_Dealer_Lite_Toggle_Control( $wp_customize, 'auto_dealer_lite_featured_car_show_hide', array(
		'label'       => esc_html__( 'Show / Hide section', 'auto-dealer-lite' ),
		'section'     => 'auto_dealer_lite_featured_car_section',
		'type'        => 'toggle',
		'settings'    => 'auto_dealer_lite_featured_car_show_hide',
	) ) );

	$wp_customize->add_setting('auto_dealer_lite_featured_car_section_short_title', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));	
	$wp_customize->add_control('auto_dealer_lite_featured_car_section_short_title', array(
		'label'    => __('Short Title','auto-dealer-lite'),
		'section'  => 'auto_dealer_lite_featured_car_section',
		'type'     => 'text',
	));

	$wp_customize->selective_refresh->add_partial( 'auto_dealer_lite_featured_car_section_short_title', array(
		'selector'        => '#featured-car h2',
		'render_callback' => 'auto_dealer_lite_customize_partial_auto_dealer_lite_featured_car_section_short_title',
	) );

	$wp_customize->add_setting('auto_dealer_lite_featured_car_section_tittle', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));	
	$wp_customize->add_control('auto_dealer_lite_featured_car_section_tittle', array(
		'label'    => __('Main Title','auto-dealer-lite'),
		'section'  => 'auto_dealer_lite_featured_car_section',
		'type'     => 'text',
	));

	$wp_customize->selective_refresh->add_partial( 'auto_dealer_lite_featured_car_section_tittle', array(
		'selector'        => '#featured-car h3',
		'render_callback' => 'auto_dealer_lite_customize_partial_auto_dealer_lite_featured_car_section_tittle',
	) );

	$wp_customize->add_setting('auto_dealer_lite_featured_car_button_text', array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	));	
	$wp_customize->add_control('auto_dealer_lite_featured_car_button_text', array(
		'label'    => __('Button Text','auto-dealer-lite'),
		'section'  => 'auto_dealer_lite_featured_car_section',
		'type'     => 'text',
	));

	$wp_customize->add_setting('auto_dealer_lite_featured_car_button_link', array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	));	
	$wp_customize->add_control('auto_dealer_lite_featured_car_button_link', array(
		'label'    => __('Button Link','auto-dealer-lite'),
		'section'  => 'auto_dealer_lite_featured_car_section',
		'type'     => 'url',
	));

	$categories = get_categories();
		$cats = array();
		$i = 0;
		$offer_cat[]= 'select';
		foreach($categories as $category){
			if($i==0){
				$default = $category->slug;
				$i++;
			}
			$offer_cat[$category->slug] = $category->name;
		}
		$wp_customize->add_setting('auto_dealer_lite_featured_car_section_category',array(
			'default'	=> 'select',
			'sanitize_callback' => 'automobile_hub_sanitize_choices',
		));
		$wp_customize->add_control('auto_dealer_lite_featured_car_section_category',array(
			'type'    => 'select',
			'choices' => $offer_cat,
			'label' => __('Select Category','auto-dealer-lite'),
			'section' => 'auto_dealer_lite_featured_car_section',
		));

	$wp_customize->add_setting('auto_dealer_lite_num_posts', array(
		'default'           => 2,
		'sanitize_callback' => 'absint',
	));	
	$wp_customize->add_control('auto_dealer_lite_num_posts', array(
		'label'    => __('Number of Featured Cars', 'auto-dealer-lite'),
		'section'  => 'auto_dealer_lite_featured_car_section',
		'type'     => 'number',
		'input_attrs' => array(
			'min'   => 1,
			'step'  => 1,
		),
	));

	$auto_dealer_lite_num_posts = get_theme_mod('auto_dealer_lite_num_posts', 3);

	for ($i = 1; $i <= $auto_dealer_lite_num_posts; $i++) {
		$wp_customize->add_setting( 'auto_dealer_lite_compare_price' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_compare_price' . $i, array(
			'label'    => sprintf(__('Compare Price %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
		
		$wp_customize->add_setting( 'auto_dealer_lite_body_type' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_body_type' . $i, array(
			'label'    => sprintf(__('Body Type %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
		
		$wp_customize->add_setting( 'auto_dealer_lite_model_year' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_model_year' . $i, array(
			'label'    => sprintf(__('Model Year %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
		
		$wp_customize->add_setting( 'auto_dealer_lite_engine_type' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_engine_type' . $i, array(
			'label'    => sprintf(__('Engine Type %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
		
		$wp_customize->add_setting( 'auto_dealer_lite_car_color' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_car_color' . $i, array(
			'label'    => sprintf(__('Car Color %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
		
		$wp_customize->add_setting( 'auto_dealer_lite_mileage' . $i, array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		));
		$wp_customize->add_control( 'auto_dealer_lite_mileage' . $i, array(
			'label'    => sprintf(__('Mileage %d','auto-dealer-lite'), $i),
			'section'  => 'auto_dealer_lite_featured_car_section',
			'type'     => 'text',
		));
	}

	// Pro Version
    $wp_customize->add_setting( 'auto_dealer_lite_services_pro_version_logo', array(
        'sanitize_callback' => 'auto_dealer_lite_sanitize_custom_control'
    ));
    $wp_customize->add_control( new auto_dealer_lite_Customize_Pro_Version ( $wp_customize,'auto_dealer_lite_services_pro_version_logo', array(
        'section'     => 'auto_dealer_lite_featured_car_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'auto-dealer-lite' ),
        'description' => esc_url( AUTOMOBILE_HUB_PRO_THEME_URL ),
        'priority'    => 10,
    )));

}
add_action( 'customize_register', 'auto_dealer_lite_customize_register' );